<?php
// $Id: post.php,v 1.85 2008/06/18 15:58:36 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
include 'header.php';
include_once('./include/thumb.php');
include_once('./class/mbfunction.class.php');
include_once('./class/notify.class.php');

foreach (array('forum','topic_id','post_id','pid','nohtml','nosmiley','icon','attachsig') as $getint) {
	${$getint} = isset($_POST[$getint]) ? intval($_POST[$getint]) : 0;
}
$viewmode = (isset($_POST['viewmode']) && $_POST['viewmode'] != 'flat') ? 'thread' : 'flat';
$order = (!isset($_GET['order']) || $_GET['order'] != "ASC") ? "DESC" : "ASC";
$invisible = (isset($_POST['contents_invisible']) && !empty($_POST['contents_invisible']) ) ? 1 : 0;
$msgview = (isset($_GET['msgview']) && $_GET['msgview'] == '0') ? 0 : 1;

if ( empty($forum) ) {
	redirect_header("index.php", 2, _MD_ERRORFORUM);
	exit();
} else {
	$sql = "SELECT forum_type, forum_name, forum_access, allow_html, allow_sig, posts_per_page, hot_threshold, topics_per_page FROM "
		.$xoopsDB->prefix("bb_forums")." WHERE forum_id = ".$forum;
	if ( !$result = $xoopsDB->query($sql) ) {
		redirect_header('index.php',2,_MD_ERROROCCURED);
		exit();
	}
	$forumdata = $xoopsDB->fetchArray($result);
	// GIJ Patch
	if( empty( $forumdata['allow_html'] ) ) $_POST['nohtml'] = 1 ;

	if ( $forumdata['forum_type'] == 1 ) {
	// To get here, we have a logged-in user. So, check whether that user is allowed to view
	// this private forum.
		$permission = 0x1ff; // Uploadfile permission (vote=admin,comment=admin,view=admin)
		$accesserror = 0;
		if ( $xoopsUser ) {
			if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
				if ( !check_priv_forum_auth($xoopsUser->uid(), $_POST['forum'], true) ) {
					$accesserror = 1;
				}
			}
		} else {
			$accesserror = 1;
		}

		if ( $accesserror == 1 ) {
			redirect_header("viewforum.php?order=".$order."&viewmode=".$viewmode."&forum=".$forum,2,_MD_NORIGHTTOPOST);
			exit();
		}
	} else {
		$permission = 0x00; // Uploadfile permission (vote=guest,comment=guest,view=guest)
		$accesserror = 0;
		if ( $forumdata['forum_access'] == 3 ) {
			if ( $xoopsUser ) {
				if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
					if ( !is_moderator($forum, $xoopsUser->uid()) ) {
						$accesserror = 1;
					}
				}
			} else {
				$accesserror = 1;
			}
		} elseif ( $forumdata['forum_access'] == 1 && !$xoopsUser ) {
			$accesserror = 1;
		}
		if ( $accesserror == 1 ) {
			redirect_header("viewforum.php?order=".$order."&viewmode=".$viewmode."&forum=".$forum,2,_MD_NORIGHTTOPOST);
			exit();
		}
    }
	if ( !empty($_POST['contents_preview']) ) {
	    if ( ! $xoopsGTicket->check() ) {
			redirect_header(XOOPS_URL.'/',3,$xoopsGTicket->getErrors());
   		}
		include XOOPS_ROOT_PATH."/header.php";
		$myts =& MyTextSanitizer::getInstance();
		$p_subject = $myts->makeTboxData4Preview($_POST['subject']);
		$nosmiley = !empty($_POST['nosmiley']) ? 1 : 0;
		$nohtml = !empty($_POST['nohtml']) ? 1 : 0;
		$message = get_uploadfile($_POST['message'],$permission);		// By yoshis
		if ( $nosmiley && $nohtml ) {
			$p_message = $myts->makeTareaData4Preview($message,0,0,1);
		} elseif ( $nohtml ) {
			$p_message = $myts->makeTareaData4Preview($message,0,1,1);
		} elseif ( $nosmiley ) {
			$p_message = $myts->makeTareaData4Preview($message,1,0,1);
		} else {
			$p_message = $myts->makeTareaData4Preview($message,1,1,1);
		}
		//themecenterposts($p_subject,$p_message);
		$ispreview = 1; // BY MAKINOSUKE
		$xoopsTpl->assign("tplsig_edit_ispreview", $ispreview); // BY MAKINOSUKE @2008/4/27
		$xoopsTpl->assign("lang_edit_ref_subject", $p_subject); // BY MAKINOSUKE @2008/4/27
		$xoopsTpl->assign("xhstr_edit_ref_message", $p_message); // BY MAKINOSUKE @2008/4/27
		$xoopsTpl->assign("lang_edit_editpost", _MD_EDIT_EDITPOST); // BY MAKINOSUKE @2008/4/27
		$subject = $myts->makeTboxData4PreviewInForm($_POST['subject']);
		$message = $myts->makeTareaData4PreviewInForm($message);
		$hidden = isset($_POST['hidden']) ? $myts->makeTboxData4PreviewInForm($_POST['hidden']) : NULL;
        $notify = !empty($_POST['notify']) ? 1 : 0;
		$attachsig = !empty($_POST['attachsig']) ? 1 : 0;
		//include $BB_CNF['spaw_path'].'spaw_control.class.php' ;
		// ******************** BY MAKINOSUKE @2008/4/17 ********************
		$xoopsOption['template_main'] =  'newbb_edit.html';
		$xoopsTpl->assign("lang_edit_pagetitle", _MD_EDIT_PREV); // BY MAKINOSUKE @2008/4/27
		// ******************** BY MAKINOSUKE @2008/4/17 ********************
		$xoopsTpl->assign( 'xoops_module_header', 
		  '<link rel="stylesheet" type="text/css" media="screen,tv,print" href="style.css" />
		  <!-- jQuery -->
		  <script type="text/javascript" src="js/jquery-1.2.6.min.js"></script>
		  <!-- markItUp! -->
		  <script type="text/javascript" src="js/markitup/jquery.markitup.pack.js"></script>
		  <!-- markItUp! toolbar settings -->
		  <script type="text/javascript" src="js/markitup/sets/bbcode/set.js"></script>
		  <!-- markItUp! skin -->
		  <link rel="stylesheet" type="text/css" href="js/markitup/skins/simple/style.css" />
		  <!--  markItUp! toolbar skin -->
		  <link rel="stylesheet" type="text/css" href="js/markitup/sets/bbcode/style.css" />
		'); //BY MAKINOSUKE @2008/5/8
		include 'include/forumform.inc.php';
	} else {
	    if ( ! $xoopsGTicket->check() ) {
			//redirect_header(XOOPS_URL.'/',3,$xoopsGTicket->getErrors());
			redirect_header(xoops_getenv('PHP_SELF'),3,$xoopsGTicket->getErrors());
   		}
		include_once 'class/class.forumposts.php';
		if ( !empty($post_id) ) {
			$editerror = 0;
			$forumpost = new ForumPosts($post_id);
			if ( $xoopsUser ) {
				if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
					if ($forumpost->islocked() || ($forumpost->uid() != $xoopsUser->getVar("uid") && !is_moderator($forum, $xoopsUser->getVar("uid")))) {
						$editerror = 1;
					}
				}
			} else {
				$editerror = 1;
			}
			if ( $editerror == 1 ) {
				redirect_header("viewtopic.php?topic_id=".$topic_id."&post_id=".$post_id."&order=".$order."&viewmode=".
					$viewmode."&pid=".$pid."&forum=".$forum,2,_MD_EDITNOTALLOWED);
				exit();
			}
			$editor = $xoopsUser->getUnameFromId($forumpost->uid(),$xoopsModuleConfig['show_name']);
			if (!$editor) $editor = $xoopsUser->getUnameFromId($forumpost->uid());
   			$on_date = _MD_ON." ".formatTimestamp(time());
			//$message .= "\n\n<small>[ "._MD_EDITEDBY." ".$editor." ".$on_date." ]</small>";
		} else {
			$isreply = 0;
			$isnew = 1;
			if ( $xoopsUser && empty($_POST['noname']) ) {
				$uid = $xoopsUser->getVar("uid");
			} else {
				if ( $forumdata['forum_access'] == 2 ) {
					$uid = 0;
				} else {
					if ( !empty($topic_id) ) {
						redirect_header("viewtopic.php?topic_id=".$topic_id."&order=".$order."&viewmode=".$viewmode."&pid=".$pid."&forum=".$forum,2,_MD_ANONNOTALLOWED);
					} else {
						redirect_header("viewforum.php?forum=".$forum,2,_MD_ANONNOTALLOWED);
					}
					exit();
				}
			}
			$forumpost = new ForumPosts();
			$forumpost->setForum($forum);
			if (isset($pid) && $pid != "") {
				$forumpost->setParent($pid);
			}
			if (!empty($topic_id)) {
				$forumpost->setTopicId($topic_id);
				$isreply = 1;
			}
			$forumpost->setIp($_SERVER['REMOTE_ADDR']);
			$forumpost->setUid($uid);
		}
		$subject = xoops_trim($_POST['subject']);
		$subject = ($subject == '') ? _NOTITLE : $subject;
		$addmsg = $_POST['message'];
		$forumpost->setSubject($subject);
		//$forumpost->setText($_POST['message']);
		$addmsg = get_uploadfile( $addmsg , $permission );
		$forumpost->setText( $addmsg );	// By Y.Sakai
		$forumpost->setNohtml($nohtml);
		$forumpost->setNosmiley($nosmiley);
		$forumpost->setIcon($icon);
		$forumpost->setAttachsig($attachsig);
		$forumpost->setInvisible($invisible);
		if (!$postid = $forumpost->store()) {
			include_once(XOOPS_ROOT_PATH.'/header.php');
			xoops_error('Could not insert forum post');
			include_once(XOOPS_ROOT_PATH.'/footer.php');
			exit();
		}
		if (is_object($xoopsUser) && !empty($isnew)) {
			$xoopsUser->incrementPost();
		}

		// set u2t_marked
		$uid = is_object( @$xoopsUser ) ? $xoopsUser->getVar('uid') : 0 ;
		$topic_id = $forumpost->topic() ;
		if( $uid > 0 ) {
			$xoopsDB->query( "UPDATE ".$xoopsDB->prefix("bb_users2topics")." SET u2t_marked=1 , u2t_time=".time()
				." WHERE uid='$uid' AND topic_id='$topic_id'" ) ;
			if( ! $xoopsDB->getAffectedRows() )
				$xoopsDB->query('INSERT INTO '.$xoopsDB->prefix('bb_users2topics')
					." SET uid='$uid',topic_id='$topic_id',u2t_marked=1 , u2t_time=".time() ) ;
		}
		// RMV-NOTIFY
		// Define tags for notification message
		$myts =& MyTextSanitizer::getInstance();
		$tags = array();
		$tags['THREAD_NAME'] = $_POST['subject'];
		$tags['THREAD_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . '/viewtopic.php?forum=' . $forum . '&post_id='.$postid.'&topic_id=' . $forumpost->topic();
		$tags['POST_URL'] = $tags['THREAD_URL'] . '#forumpost' . $postid;
		$tags['POST_CONTENT'] = $myts->stripSlashesGPC($_POST['message']);
		$tags['POST_NAME'] = $tags['THREAD_NAME'] = $myts->htmlSpecialChars($myts->stripSlashesGPC($_POST['subject']));
		include_once 'include/notification.inc.php';
		$forum_info = newbb_notify_iteminfo ('forum', $forum);
		$tags['FORUM_NAME'] = $forum_info['name'];
		$tags['FORUM_URL'] = $forum_info['url'];
        if(is_object($xoopsUser)){
            $tags['EDITOR'] = $xoopsUser->getVar("uname");  // added 2003-12 hhankt
        }
		$notification_handler =& xoops_gethandler('notification') ;
		if( (!empty($_POST['post_id']) && $forumpost->invisible2see==false) || $invisible ) {
			$mode = 'edit' ;
		} else if( !empty( $_POST['pid']) ) {
			$mode = 'reply' ;
		} else {
			$mode = 'newtopic' ;
		}
		//echo $mode.",".$_POST['post_id'].",".$forumpost->invisible2see.",".$invisible;
		if( $mode != 'edit' ) {
			if ( $forumdata['forum_type'] == 1 ) {
				// PRIVATE FORUM
				$notify = new notify();
				$users2notify = $notify->get_users_can_read_forum( $forum ) ;
				if( empty( $users2notify ) ) $users2notify = array( 0 ) ;
			} else {
				// PUBLIC FORUM
				$users2notify = array() ;
			}
			if( $mode == 'reply' ) {
				// Notify of new thread
				$notification_handler->triggerEvent('thread', $topic_id, 'new_post', $tags , $users2notify );
                $notification_handler->triggerEvent('thread', $topic_id, 'new_fullpost',$tags , $users2notify ); // added 2003-12-04 hhankt
			} else {
				// Notify of new post
				$notification_handler->triggerEvent('forum', $forum, 'new_thread', $tags , $users2notify );
			}
			$notification_handler->triggerEvent('forum', $forum, 'new_post', $tags , $users2notify );
			$notification_handler->triggerEvent('forum', $forum, 'new_fullpost',$tags , $users2notify );  //added 2003-12-04 hhankt
			$notification_handler->triggerEvent('global', 0, 'new_post', $tags , $users2notify );
			$notification_handler->triggerEvent('global', 0, 'new_fullpost', $tags , $users2notify );
		}
		// If user checked notification box, subscribe them to the
		// appropriate event; if unchecked, then unsubscribe
		if (!empty($xoopsUser) && !empty($xoopsModuleConfig['notification_enabled']) 
			&& in_array('thread-new_post',@$xoopsModuleConfig['notification_events'])){
			if (!empty($_POST['notify'])) {
				$notification_handler->subscribe('thread', $forumpost->getTopicId(), 'new_post');
			} else {
				$notification_handler->unsubscribe('thread', $forumpost->getTopicId(), 'new_post');
			}
		}

		if ( $_POST['viewmode'] == "flat" ) {
			redirect_header("viewtopic.php?topic_id=".$forumpost->topic()."&amp;post_id=".$postid."&amp;order=".$order."&amp;viewmode=flat&amp;pid=".$pid."&amp;forum=".$forum."#forumpost".$postid."",2,_MD_THANKSSUBMIT);
			exit();
		} else {
			$post_id = $forumpost->postid();
			redirect_header("viewtopic.php?topic_id=".$forumpost->topic()."&amp;post_id=".$postid."&amp;order=".$order."&amp;viewmode=thread&amp;pid=".$pid."&amp;forum=".$forum."#forumpost".$postid."",2,_MD_THANKSSUBMIT);
			exit();
		}
	}
	include XOOPS_ROOT_PATH.'/footer.php';
}
/*
** file upload by Y.Sakai @ bluemooninc.biz  2004/3/14
*/
function getimagetype($data){
    if (strncmp("\x00\x00\x01\x00", $data, 4) == 0) {
        // ICO
        return "ico";
    } else if (strncmp("\x89PNG\x0d\x0a\x1a\x0a", $data, 8) == 0) {
        // PNG
        return "png";
    } else if (strncmp('BM', $data, 2) == 0) {
        // BMP
        return "bmp";
    } else if (strncmp('GIF87a', $data, 6) == 0 || strncmp('GIF89a', $data, 6) == 0) {
        // GIF
        return "gif";
    } else if (strncmp("\xff\xd8", $data, 2) == 0) {
        // JPEG
        return "jpg";
    } else {
        return false;
    }
}
function get_uploadfile($addmsg,$permission=0) {
	global $xoopsUser,$xoopsModuleConfig,$bbUrl;
	global $viri,$imgtype,$embedtype,$embed_w,$embed_h,$thumb_ext,$w,$h,$img_dir,$thumb_dir,$upload_acclevel;
	
	if (!$_FILES) return $addmsg;
	$subtype = $xoopsModuleConfig['uploadtypes'];
	$permission = sprintf("%03d",$permission);
    $upfile       = $_FILES['upfile'];					//upload file object 
    $upfile_tmp   = $_FILES['upfile']['tmp_name'];     //tmp file name 
    $upfile_name  = basename($_FILES['upfile']['name']);	//Local File Name ( Use basename for security )
    $upfile_name  = (get_magic_quotes_gpc()) ? stripslashes($upfile_name) : $upfile_name;
    $upfile_size  = $_FILES['upfile']['size'];        //File Size
    $upfile_type  = $_FILES['upfile']['type'];        //File MIME Content-Type
    $upfile_error = $_FILES['upfile']['error'];		//upload file error no
    if ( $upfile_error > 0 ){
    	switch ($upfile_error){
    		case UPLOAD_ERR_INI_SIZE: echo "Over upload_max_filesize on php.ini"; break;
    		case UPLOAD_ERR_FORM_SIZE: echo "Over MAX_FILE_SIZE at form"; break;
    		case UPLOAD_ERR_PARTIAL: echo "An error occured while trying to recieve the file. Please try again."; break;
    		case UPLOAD_ERR_NO_FILE: /*echo "No Upload File.";*/ break;
			default: echo "Unknown Error - ".$upfile_error; print_r($_FILES); break;
		}
    } 
	if ( $upfile_tmp != "" && ( is_object($xoopsUser) || $upload_acclevel == 0 ) ){
		// Disp File Infomation for debug
		//print("File Infomation:<BR>\n");
		//print("File From : $upfile_tmp<BR>\n");
		//print("File To : $upfile_name<BR>\n");
		//print("File Size - $upfile_size<BR>\n");
		//print("File type - $upfile_type<BR>\n");
		if (eregi($subtype, $upfile_type)){ $deny=0; } else { $deny=1; };
		$ext = strtolower(end(explode(".",$upfile_name))); 
		if (eregi($viri, $ext)) $deny = 1;
		$uname = $xoopsUser ? mb_func::internal2x( $xoopsUser->getVar('uname'), $xoopsModuleConfig['filename_code'] ) : "Anonymous" ;
		if (eregi($imgtype, $upfile_type)){
			$size = getimagesize($upfile_tmp);
			$type = getimagetype($upfile_tmp);
			if ( !$size || !strcmp($type,$upfile_type) ) return $addmsg." ERROR: getimagesize(".$size."),type(".$type.") ".$upfile_type;
			$upfile_localname = $uname."_".time().$permission."_".$upfile_name;
			$upfile_url = XOOPS_URL.$img_dir.rawurlencode(mb_func::internal2x($upfile_localname,$xoopsModuleConfig['filename_code']));
    	    $upfile_path = XOOPS_ROOT_PATH.$img_dir.mb_func::internal2x($upfile_localname,$xoopsModuleConfig['filename_code']);
    	    move_uploaded_file($upfile_tmp,$upfile_path);
			chmod($upfile_path,0644);
			// Thumbs Support ( PHP GD Libraly Required )
			if (eregi($thumb_ext,strtolower($upfile_localname))) {
				if ($size[0] > $w || $size[1] > $h) {
					$thumb_localname = thumb_create($upfile_path,$w,$h,XOOPS_ROOT_PATH.$thumb_dir);
					$thumbfile_url = XOOPS_URL.$thumb_dir.rawurlencode($thumb_localname);
					$addmsg .= "\n[url=".$upfile_url."][img]"
					 .$thumbfile_url."[/img][/url]\n";
				} else {
					$addmsg .= "\n[img]".$upfile_url."[/img]\n";
				}
			} else {
				$addmsg .= "\n[img]".$upfile_url."[/img]\n";
			}
		} elseif (eregi($embedtype, $upfile_type)){
			$upfile_localname = $uname."_".time().$permission."_".mb_func::internal2x($upfile_name,$xoopsModuleConfig['filename_code']);
			$upfile_url = XOOPS_URL.$img_dir.rawurlencode($upfile_localname);
    	    $upfile_path = XOOPS_ROOT_PATH.$img_dir.$upfile_localname;
    	    move_uploaded_file($upfile_tmp,$upfile_path);
			chmod($upfile_path,0644);
			$addmsg = "\n<EMBED src=\"".$upfile_url."\" WIDTH=\"".$embed_w."\" HEIGHT=\"".$embed_h.
				"\" autostart=\"false\" controller=\"true\" hspace=\"5\" align=\"left\" alt=\"\">".
				$addmsg."</EMBED>\n";
		} elseif ($deny==0) {
			$upfile_localname = $uname."_".$upfile_name.".".time().$permission;
			$upfile_url='/'.rawurlencode($upfile_localname);	// XOOPS_UPLOAD_URL.
			$upfile_localname = mb_func::internal2x($upfile_localname,$xoopsModuleConfig['filename_code']);
    	    $upfile_path = UPLOADS.$upfile_localname;
    	    move_uploaded_file($upfile_tmp,$upfile_path);
			chmod($upfile_path,0644);
			$addmsg .= "\n:download:";
			$addmsg .= "[url=".$bbUrl['root']."download.php?url=".$upfile_url."]".$upfile_name."[/url]\n";
		} else {
			$addmsg .= "\nUpload Denied...".$upfile_type." ext ".$ext;
		}
    }
	return $addmsg;
	// upload end
}
?>
