#include	"multi_forward.h"
#include	"config.h"

extern	void	handler(int sig);

int *parser_result(const char *buf, int size);
void    hole_punch_interval_reset (char buff[]);
void    packet_skip (void);

void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

void	keep_alive_check (void)
{
	struct	MultiConnectTable	*next;
	struct	MultiConnectTable	*prev;
	struct	MultiConnectTable	*temp;
	time_t	cur_time;

	time (&cur_time);
	prev = NULL;
	next = MultiConnectTablePnt;
	while (next)
	{
		if ((cur_time - next->AccessTime) > 30)
		{
			fprintf (log_file, "%24.24s Disconnect from %s(%d)\n",
				ctime(&cur_time), 
				inet_ntoa (next->multi_addr.sin_addr), 
				next->multi_addr.sin_port);
			fflush (log_file);
			if (prev)
			{
				prev->f_chain = next->f_chain;
				temp = next;
				next = prev->f_chain;
				free (temp);
			}
			else
			{
				MultiConnectTablePnt = next->f_chain;
				free (next);
				next = MultiConnectTablePnt;
			}
		}
		else
		{
			prev = next;
			next = next->f_chain;
		}
	}
}

char    CpuUsage[10];
int     prev_idle = 0, prev_total = 0;
void    cpu_usage (void)
{
        int size,  *nums, idle, total, i;
        char    buf[256];

        size = read(cpu_fd, buf, sizeof(buf));
        if(size <= 0) return;

        nums = parser_result(buf, size);
        idle=nums[3];
        for(i=0, total=0; i<10; i++){
                total += nums[i];
        }
        int diff_idle = idle-prev_idle;
        int diff_total = total-prev_total;
        float usage = (float)(((float)(1000*(diff_total-diff_idle))/(float)diff_total+5)/(float)10);
        sprintf(CpuUsage, "%6.2f%%", usage);

        prev_total = total;
        prev_idle = idle;
        lseek(cpu_fd, 0, SEEK_SET);
}

int *parser_result(const char *buf, int size){
        static int ret[10];
        int i, j = 0, start = 0;

        for(i=0; i<size; i++){
                char c = buf[i];
                if(c >= '0' && c <= '9'){
                        if(!start){
                                start = 1;
                                ret[j] = c-'0';
                        } else {
                                ret[j] *= 10;
                                ret[j] += c-'0';
                        }
                } else if(c == '\n'){
                        break;
                } else {
                        if(start){
                                j++;
                                start = 0;
                        }
                }
        }

        return ret;
}

void	send_hole_punch (void)
{
	struct	area_callsign	*ar_temp;
	unsigned char	hole_punch[24];
	struct	sockaddr_in hole_punch_addr;

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	struct	sockaddr_storage	hole_addr;
	socklen_t			hole_addr_len;
	char	PORT[10];
	int	ret;
	double	version;
	int	ver;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = 0;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				ar_temp = ar_callsign_pnt;
				while (ar_temp)
				{
        				memset (hole_punch, 0x00, 16);
					memcpy (hole_punch, "HPCH", 4);
        				memcpy (&hole_punch[4], ar_temp->ar_callsign, 8);
        				hole_punch[12] = (multi_port >> 8) & 0xff;
        				hole_punch[13] = multi_port & 0xff;
					version = atof(VERSION);
					ver = version;
					hole_punch[14] = ver & 0xff;
					ver = version * 100;
					hole_punch[15] = ver % 100;
					memcpy (&hole_punch[16], zr_callsign, 8);
					//hole_punch[23] = 0x20;
        				sendto(multi_sd, hole_punch, 24, 0, 
						rp->ai_addr, rp->ai_addrlen);
					ar_temp = ar_temp->next;
				}
				break;		/* new version test */
			}
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_hole_punch) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void	read_hole_punch (char buff[], int length)
{
	char	ip_add[20];
	int	port;
	int	k;
	struct	sockaddr_in	hole_addr;
	int	ret;
	int	len;

	if (length == 10)
	{
		hole_punch_interval_reset(buff);
	}
	else if ((length == 26 ) || (length == 36))
	{
		memset (ip_add, 0x00, 20);
		len = strlen (buff);
		for (k = 4 ; k < len ; k++)
		{
			if (buff[k] != ':')
			{
				ip_add[k-4] = buff[k];
			}
			else
			{
				port = atoi (&buff[k+1]);
				break;
			}
		}
        	hole_addr.sin_family = AF_INET;
        	hole_addr.sin_port = htons(port);
        	hole_addr.sin_addr.s_addr = inet_addr(ip_add);

		ret = sendto (multi_sd, buff, 25, 0, 
			(struct sockaddr *)&hole_addr, sizeof(hole_addr));
	}
}

void	hole_punch_interval_reset (char buff[])
{
	int	nat_port;

	nat_port = atoi (&buff[4]);
	if (nat_port != hole_punch_port_save)
	{
		if (hole_punch_interval == 20) hole_punch_interval = 10;
		else if (hole_punch_interval == 10) hole_punch_interval =5;
		else if (hole_punch_interval == 5) hole_punch_interval = 2;
		else if (hole_punch_interval == 2) hole_punch_interval = 1;
		hole_punch_port_save = nat_port;
	}
}
	
void	status_on (char	call[], char ur_call[], char my_call[], char rpt1_call[], char rpt2_call[])
{
	char	status_string[48];
	struct	sockaddr_in hole_punch_addr;

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	struct	sockaddr_storage	hole_addr;
	socklen_t			hole_addr_len;
	char	PORT[10];
	int	ret;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = 0;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
					memcpy (status_string, "STAT", 4);
        				memcpy (&status_string[4], call, 8);
					memcpy (&status_string[12], "ON  ", 4);
					memcpy (&status_string[16], ur_call, 8);
					memcpy (&status_string[24], my_call, 8);
					memcpy (&status_string[32], rpt1_call, 8);
					memcpy (&status_string[40], rpt2_call, 8);
        				sendto(multi_sd, status_string, 48, 0, 
						rp->ai_addr, rp->ai_addrlen);
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_on) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}


void	status_off (char call[])
{
	char	status_string[16];
	struct	sockaddr_in hole_punch_addr;

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	struct	sockaddr_storage	hole_addr;
	socklen_t			hole_addr_len;
	char	PORT[10];
	int	ret;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = 0;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				memcpy (status_string, "STAT", 4);
        			memcpy (&status_string[4], call, 8);
				memcpy (&status_string[12], "OFF ", 4);
        			sendto(multi_sd, status_string, 16, 0, 
					rp->ai_addr, rp->ai_addrlen);
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_off) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void    status_check (void)
{
        struct  area_callsign       *next_pnt;
        time_t  cur_time;

        time (&cur_time);
        next_pnt = ar_callsign_pnt;
        while (next_pnt)
        {
		if (next_pnt->status)
		{
               		if ((cur_time - next_pnt->status_time) > 3)
                        {
				if (next_pnt->status == ON)
				{
					status_off (next_pnt->ar_callsign);
					next_pnt->status = OFF;
				}
			}
                }
		next_pnt = next_pnt->next;
        }
}

int	ja_check (char callsign[])
{
	/* JA-JS,7J-7N,8J-8N */
	if (callsign[7] == 'S') return FALSE;
	if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
	if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
	if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
	return FALSE;
}

int	mycall2_check (unsigned char mycall2[])
{
	int	i;

	for (i = 0 ; i < 4 ; i++)
	{
		if (mycall2[i] == 0x00) return FALSE;
	}
	return TRUE;
}

void	trust_read (int length, unsigned char buff[])
{
	if ((buff[2] == 0x80) && (buff[3] == 0x00))
	{
		trust_status = NOP;
	}
	else
	{
		packet_skip();
	}
}

void	packet_skip (void)
{
	int	length;

	trust_status = SKIP;

	length = getFifo (multi_addr, multi_buff.multi_buffer);
	while (length) length = getFifo (multi_addr, multi_buff.multi_buffer);
}

void    putFifo (int len, struct sockaddr_in addr, unsigned char pkt[])
{
        struct	FifoPkt  *ret;

	// dup check for loop
        if ((len == Wp->length) && (len != 26))
        {
                if (!memcmp (&pkt[6], &Wp->pkt[6], len-6)) return;
        }

        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                fprintf (log_file, "memory error in gw\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
	memcpy (&ret->multi_addr, &addr, sizeof(struct sockaddr_in));
        memcpy (ret->pkt, pkt, len);
	Wp->next = ret;
        Wp = ret;
}

int     getFifo (struct sockaddr_in addr, unsigned char pkt[])
{
        struct  FifoPkt *tmp;
	int	len;

        if (Rp->next == NULL) return 0;
        tmp = Rp;
	Rp = Rp->next;
        len = Rp->length;
        memcpy (pkt, Rp->pkt, Rp->length);
	memcpy (&addr, &Rp->multi_addr, sizeof (struct sockaddr_in));
        free (tmp);
        return len;
}

void	send_inquire (char call[])
{
	unsigned char	buff[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result;
	char	PORT[10];
	int	ret;

        memset (buff, 0x00, 8);
        buff[0] = 0x01;
        buff[1] = 0x03;
        buff[4] = 0x02;
        memcpy (&buff[8], call, 8);
	trust_status = WAIT;
	gettimeofday (&send_inquire_time, NULL);
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = 0;

	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", trust_port);
	ret = getaddrinfo (trust_server, PORT, &hints, &result);
	if (ret == 0)
	{
       		ret = sendto(multi_sd, buff, 16, 0, 
			result->ai_addr, result->ai_addrlen);
		freeaddrinfo (result);
	}
}

