#include	"multi_forward.h"
#include	"config.h"

extern	void	handler(int sig);
void	ctbl(void);
void    ctbl_putFifo (unsigned char pkt[]);
int	ctbl_getFifo (unsigned char pkt[]);
void	send_not_regist (struct MultiConnectTable *pnt);
void	send_not_xmit (struct MultiConnectTable *pnt);
void    send_no_error_auth (struct MultiConnectTable *pnt);
void    send_no_error_xmit (struct MultiConnectTable *pnt);
void	position_update (char call[], char ar_call[]);

extern	struct  timeval         time_100ms;

int *parser_result(const char *buf, int size);
void    hole_punch_interval_reset (char buff[]);

void	pselectSet(void)
{
	FD_ZERO (&read_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 5000000;
}

void	keep_alive_check (void)
{
	struct	MultiConnectTable	*next;
	struct	MultiConnectTable	*prev;
	struct	FifoPkt	*Rp;
	struct	FifoPkt	*temp;
	time_t	cur_time;
	int	change_sw;

	change_sw = FALSE;
	time (&cur_time);
	prev = NULL;
	next = MultiConnectTablePnt;
	while (next)
	{
		if ((cur_time - next->AccessTime) > 30)
		{
			fprintf (log_file, "%24.24s Disconnect from %8.8s %s(%d)\n",
				ctime(&cur_time), 
				next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr), 
				next->multi_addr.sin_port);
			fflush (log_file);
                        Rp = next->Rp;
                        while (Rp)
                        {
                                temp = Rp;
                                Rp = Rp->next;;
                                free (temp);
                        }
			if (prev)
			{
				prev->f_chain = next->f_chain;
				free (next);
				next = prev->f_chain;
			}
			else
			{
				MultiConnectTablePnt = next->f_chain;
				free (next);
				next = MultiConnectTablePnt;
			}
			change_sw = TRUE;
		}
		else
		{
			prev = next;
			next = next->f_chain;
		}
	}
	if (change_sw) ctbl();
}

void	delete_MultiConnectTable (struct sockaddr_in multi_addr)
{
	struct	MultiConnectTable	*next;
	struct	MultiConnectTable	*prev;
	struct  FifoPkt *Rp;
	struct	FifoPkt	*temp;
	time_t	cur_time;

	next = MultiConnectTablePnt;
	prev = NULL;
	while (next)
	{
		if (!memcmp (&multi_addr, &next->multi_addr, sizeof (multi_addr)))
		{
			time(&cur_time);
                        fprintf (log_file, "%24.24s Disconnect from %8.8s %s(%d)\n",
                                ctime(&cur_time),
                                next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr),
                                next->multi_addr.sin_port);
                        fflush (log_file);

			Rp = next->Rp;
			while (Rp)
			{
				temp = Rp;
				Rp = Rp->next;;
				free (temp);
			}
			if (prev)
			{
				prev->f_chain = next->f_chain;
				free (next);
				next = prev->f_chain;
			}
			else
			{
				MultiConnectTablePnt = next->f_chain;
				free (next);
				next = MultiConnectTablePnt;
			}
			return;
		}
		next = next->f_chain;
	}
}

char    CpuUsage[10];
int     prev_idle = 0, prev_total = 0;
void    cpu_usage (void)
{
        int size,  *nums, idle, total, i;
        char    buf[256];

        size = read(cpu_fd, buf, sizeof(buf));
        if(size <= 0) return;

        nums = parser_result(buf, size);
        idle=nums[3];
        for(i=0, total=0; i<10; i++){
                total += nums[i];
        }
        int diff_idle = idle-prev_idle;
        int diff_total = total-prev_total;
        float usage = (float)(((float)(1000*(diff_total-diff_idle))/(float)diff_total+5)/(float)10);
        sprintf(CpuUsage, "%6.2f%%", usage);

        prev_total = total;
        prev_idle = idle;
        lseek(cpu_fd, 0, SEEK_SET);
}

int *parser_result(const char *buf, int size){
        static int ret[10];
        int i, j = 0, start = 0;

        for(i=0; i<size; i++){
                char c = buf[i];
                if(c >= '0' && c <= '9'){
                        if(!start){
                                start = 1;
                                ret[j] = c-'0';
                        } else {
                                ret[j] *= 10;
                                ret[j] += c-'0';
                        }
                } else if(c == '\n'){
                        break;
                } else {
                        if(start){
                                j++;
                                start = 0;
                        }
                }
        }

        return ret;
}

void	send_hole_punch (void)
{
	struct	area_callsign	*ar_temp;
	unsigned char	hole_punch[24];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;
	char	temp[10];
	char	*pnt;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				ar_temp = ar_callsign_pnt;
				while (ar_temp)
				{
        				memset (hole_punch, 0x00, sizeof(hole_punch));
					memcpy (hole_punch, "HPCH", 4);
        				memcpy (&hole_punch[4], ar_temp->ar_callsign, 8);
        				hole_punch[12] = (multi_port >> 8) & 0xff;
        				hole_punch[13] = multi_port & 0xff;
					memset (temp, 0x00, sizeof(temp));
					memcpy (temp, VERSION, strlen(VERSION));
					pnt = strtok(temp, ".");
					hole_punch[14] = atoi(pnt) & 0xff;
					pnt = strtok(NULL,".");
					hole_punch[15] = atoi(pnt) & 0xff;
					memcpy (&hole_punch[16], zr_callsign, 8);
					//hole_punch[23] = 0x20;
        				ret = sendto(multi_sd, hole_punch, 24, 0, 
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s hole_punch error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					ar_temp = ar_temp->next;
				}
				break;		/* new version test */
			}
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_hole_punch) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void	read_hole_punch (char buff[], int length)
{
	char	ip_add[20];
	int	port;
	int	k;
	struct	sockaddr_in	hole_addr;
	int	ret;
	int	len;
	time_t	atime;

	port = multi_port;
	if (length == 10)
	{
		hole_punch_interval_reset(buff);
	}
	else if ((length == 26) || (length == 36))
	{
		memset (ip_add, 0x00, 20);
		len = strlen (buff);
		for (k = 4 ; k < len ; k++)
		{
			if (buff[k] != ':')
			{
				ip_add[k-4] = buff[k];
			}
			else
			{
				port = atoi (&buff[k+1]);
				break;
			}
		}
        	hole_addr.sin_family = AF_INET;
        	hole_addr.sin_port = htons(port);
        	hole_addr.sin_addr.s_addr = inet_addr(ip_add);

		ret = sendto (multi_sd, buff, 25, 0, 
			(struct sockaddr *)&hole_addr, sizeof(hole_addr));
                if (ret == -1)
                {
                        time(&atime);
                        fprintf (log_file, "%24.24s mult hole_punch ack error %s\n", ctime(&atime), strerror(errno));
                        fflush (log_file);
                }
			
	}
}

void	hole_punch_interval_reset (char buff[])
{
	int	nat_port;
	time_t	atime;

	nat_port = atoi (&buff[4]);
	if (nat_port != hole_punch_port_save)
	{
		time(&atime);
		fprintf (log_file, "%24.24s port number changed %d -> %d\n",
			ctime(&atime), hole_punch_port_save, nat_port);
		fflush (log_file);
		hole_punch_port_save = nat_port;
		if (hole_punch_interval == 20) hole_punch_interval = 10;
		else if (hole_punch_interval == 10) hole_punch_interval =5;
		else if (hole_punch_interval == 5) hole_punch_interval = 2;
		else if (hole_punch_interval == 2) hole_punch_interval = 1;
	}
}
	
void	status_on (char	call[], char ur_call[], char my_call[], char rpt1_call[], char rpt2_call[])
{
	char	status_string[48];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
					memcpy (status_string, "STAT", 4);
        				memcpy (&status_string[4], call, 8);
					memcpy (&status_string[12], "ON  ", 4);
					memcpy (&status_string[16], ur_call, 8);
					memcpy (&status_string[24], my_call, 8);
					memcpy (&status_string[32], rpt1_call, 8);
					memcpy (&status_string[40], rpt2_call, 8);
        				ret = sendto(multi_sd, status_string, 48, 0, 
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s satus_on error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_on) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}


void	status_off (char call[])
{
	char	status_string[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				memcpy (status_string, "STAT", 4);
        			memcpy (&status_string[4], call, 8);
				memcpy (&status_string[12], "OFF ", 4);
        			ret = sendto(multi_sd, status_string, 16, 0, 
					rp->ai_addr, rp->ai_addrlen);
                		if (ret == -1)
                		{
                        		time(&atime);
                        		fprintf (log_file, "%24.24s status_off error %s\n", ctime(&atime), strerror(errno));
                        		fflush (log_file);
                		}
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_off) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void    status_check (void)
{
        struct  area_callsign       *next_pnt;
        time_t	cur_time;

        time (&cur_time);
        next_pnt = ar_callsign_pnt;
        while (next_pnt)
        {
               	if ((cur_time - next_pnt->status_time) >= 3)
                {
			if (next_pnt->status == ON)
			{
				status_off (next_pnt->ar_callsign);
				next_pnt->status = OFF;
				memset (next_pnt->FrameID, 0x00, 2);
			}
		}
		next_pnt = next_pnt->next;
        }
}

int	ja_check (char callsign[])
{
	/* JA-JS,7J-7N,8J-8N */
	if (callsign[7] == 'S') return FALSE;
	if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
	{
		if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
		if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
		if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
	}
	return FALSE;
}

int	mycall2_check (unsigned char mycall2[])
{
	int	i;

	for (i = 0 ; i < 4 ; i++)
	{
		if (mycall2[i] == 0x00) return FALSE;
	}
	return TRUE;
}

void	trust_read (int length, unsigned char buff[])
{
	struct MultiConnectTable	*next;
	time_t	atime;

	if (buff[2] == 0x80)
	{
		next = MultiConnectTablePnt;
		while (next)
		{
			if (!memcmp (next->auth_callsign, &buff[8], 8))
			{
				if (buff[3] == 0x00) 
				{
					if (next->auth != AUTH_TRUE)
					{
						next->auth = AUTH_TRUE;
						time (&atime);
        					fprintf (log_file, "%24.24s Connect from %8.8s %s(%d)\n", ctime(&atime),
              					next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
        					fflush (log_file);
						ctbl();
						send_no_error_auth (next);
					}
				}
				else if (buff[3] == 0x01)
				{
					time(&atime);
					fprintf (log_file, "%24.24s not regist.(connect) callsign %8.8s %s(%d)\n", ctime(&atime), 
						next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
					fflush (log_file);		 
					next->auth = AUTH_FALSE;
					send_not_regist (next);
				}
			}
			if (!memcmp (next->xmit_callsign, &buff[8], 8))
			{
				if (buff[3] == 0x00)
				{
					if (next->xmit != XMIT_TRUE)
						position_update(&buff[8], next->ar_callsign);
					next->xmit = XMIT_TRUE;
					send_no_error_xmit(next);
				}
				else if (buff[3] == 0x01) 
				{
					time(&atime);
					next->xmit = XMIT_FALSE;
					fprintf (log_file, "%24.24s not regist.(XMIT) callsign %8.8s %s(%d)\n", ctime(&atime), 
						next->xmit_callsign, inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
					fflush (log_file);
					send_not_xmit (next);
				}
			}
			next = next->f_chain;
		} 
	}
}


void    putFifo (int len, struct MultiConnectTable *pnt, unsigned char pkt[])
{
        struct	FifoPkt  *ret;
	time_t	atime;

	time(&atime);
        if ((len == pnt->Wp->length) && (len != 26))
        {
                if (!memcmp (&pkt[6], &pnt->Wp->pkt[6], len-6))
		{
			fprintf (log_file, "%24.24s dup. packet frame seq:%2.2x\n", ctime(&atime), pkt[16]);
			fflush (log_file);
			return;
		}
        }
        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                fprintf (log_file, "%24.24s memory error in gw\n", ctime(&atime));
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (ret->pkt, pkt, len);
	pnt->Wp->next = ret;
        pnt->Wp = ret;
}

int     getFifo (struct MultiConnectTable *pnt, unsigned char pkt[])
{
        struct  FifoPkt *tmp;
	int	len;
	char	auth;
	char	xmit;

	if (pnt == NULL) return 0;
        if (pnt->Rp->next == NULL) return 0;
	if (pnt->auth == AUTH_WAIT) return 0;
	if (pnt->xmit == XMIT_WAIT) return 0;
        tmp = pnt->Rp;
	pnt->Rp = pnt->Rp->next;
        len = pnt->Rp->length;
        memcpy (pkt, pnt->Rp->pkt, pnt->Rp->length);
	auth = pnt->auth;
	xmit = pnt->xmit;
        free (tmp);
        if ((auth == AUTH_TRUE) && (xmit == XMIT_TRUE)) return len;
	return 0;
}

void	send_inquire (char call[])
{
	unsigned char	buff[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result;
	char	PORT[10];
	int	ret;
	time_t	atime;

        memset (buff, 0x00, 8);
        buff[0] = 0x01;
        buff[1] = 0x03;
        buff[4] = 0x02;
        memcpy (&buff[8], call, 8);
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", trust_port);
	ret = getaddrinfo (trust_server, PORT, &hints, &result);
	if (ret == 0)
	{
       		ret = sendto(multi_sd, buff, 16, 0, 
			result->ai_addr, result->ai_addrlen);
               	if (ret == -1)
               	{
                       	time(&atime);
                       	fprintf (log_file, "%24.24s inquire error %s\n", ctime(&atime), strerror(errno));
                       	fflush (log_file);
               	}
		freeaddrinfo (result);
	}
	else 
	{
		time(&atime);
		fprintf (log_file, "%24.24s getaddrinfo error (send_inquire) %s\n", ctime(&atime), gai_strerror(ret));
		fflush (log_file);
	}
}

void	trust_resp_check(void)
{
	struct	MultiConnectTable	*next;
	struct	timeval		atime;
	struct	timeval		temp_time;

	gettimeofday (&atime, NULL);
	next = MultiConnectTablePnt;
	while (next)
	{
                timeradd (&next->AuthInquireTime, &time_100ms, &temp_time);
                if (timercmp (&atime, &temp_time, >))
                {
			if (next->auth == AUTH_WAIT) next->auth = AUTH_FALSE;
		}
		timeradd (&next->XmitInquireTime, &time_100ms, &temp_time);
		if (timercmp (&atime, &temp_time, >))
		{
			if (next->xmit == XMIT_WAIT) next->xmit = XMIT_FALSE;
		}
		next = next->f_chain;
	}
}

void	ctbl(void)
{
	struct	MultiConnectTable	*pnt;
	unsigned char	buff[44];
	int	k;

	pnt = MultiConnectTablePnt;
	if (pnt == NULL) return;

	k = 0;
	memcpy (buff, "CTBL", 4);
	memset (&buff[4], 0x00, 40);
	memcpy (&buff[4], "START", 5);
	sprintf ((char *)&buff[10], "%s", PACKAGE_STRING);
	ctbl_putFifo (buff);
	memset (&buff[4], 0x00, 40);
	while (pnt)
	{
		if (pnt->auth == AUTH_TRUE)
		{
			memcpy (&buff[k*8+4], pnt->auth_callsign, 8);
			k++;
			if (k == 5)
			{
				ctbl_putFifo(buff);
				k = 0;
				memset (&buff[4], 0x00, 40);
			}
		}	
		pnt = pnt->f_chain;
	}
	if (k)
	{
		ctbl_putFifo(buff);
	}
	memset (&buff[4], 0x00, 40);
	memcpy (&buff[4], "END", 3);
	sprintf ((char *)&buff[10], "%s", PACKAGE_STRING);
	ctbl_putFifo(buff);
}

void    ctbl_putFifo (unsigned char pkt[])
{
        struct  ctblPkt  *ret;

        ret = malloc (sizeof(struct ctblPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error in gw\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        memcpy (ret->pkt, pkt, 44);
        ctblWp->next = ret;
        ctblWp = ret;
}

int     ctbl_getFifo (unsigned char pkt[])
{
        struct  ctblPkt *tmp;

        if (ctblRp->next == NULL) return 0;
        tmp = ctblRp;
        ctblRp = ctblRp->next;
        memcpy (pkt, ctblRp->pkt, 44);
        free (tmp);
	return 44;
}

void	ctbl_send(void)
{
	struct	MultiConnectTable	*next;
	unsigned char	buff[44];
	int	ret;
	time_t	atime;

	if (ctbl_getFifo (buff) == 0) return;
	next = MultiConnectTablePnt;
        while (next)
        {
        	ret = sendto (multi_sd, buff, 44, 0,
               		(struct sockaddr *)&next->multi_addr,
                       	sizeof(struct sockaddr));
               	if (ret == -1)
               	{
                       	time(&atime);
                       	fprintf (log_file, "%24.24s ctbl_send error %s\n", 
				ctime(&atime), strerror(errno));
                       	fflush (log_file);
               	}
                next = next->f_chain;
	}
}

void	send_not_regist(struct MultiConnectTable *pnt)
{
	unsigned char	buff[44];
	
	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 39);
	sprintf (&buff[5], "%8.8s Not registed(connect)", pnt->auth_callsign);
        sendto (multi_sd, buff, 44, 0,
        	(struct sockaddr *)&pnt->multi_addr,sizeof(struct sockaddr));
}

void	send_not_xmit (struct MultiConnectTable *pnt)
{
	unsigned char	buff[44];

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 39);
	sprintf (&buff[5], "'%8.8s' Not registed(Xmit)", pnt->xmit_callsign);
	sendto (multi_sd, buff, 44, 0,
		 (struct sockaddr *)&pnt->multi_addr,sizeof(struct sockaddr));
}

void	send_no_error_auth (struct MultiConnectTable *pnt)
{
	unsigned char   buff[44];

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 39);
        sprintf (&buff[5], "'%8.8s' registed.", pnt->auth_callsign);
	sendto (multi_sd, buff, 44, 0,
		(struct sockaddr *)&pnt->multi_addr, sizeof(struct sockaddr));
}

void	send_invalid_call (char call[], struct sockaddr_in multi_addr)
{
	unsigned char   buff[44];

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 39);
	sprintf (&buff[5], "Invalid callsign '%8.8s'", call);
	sendto (multi_sd, buff, 44, 0,
		(struct sockaddr *)&multi_addr, sizeof(struct sockaddr_in));
}

void    send_no_error_xmit (struct MultiConnectTable *pnt)
{
        unsigned char   buff[44];

        memcpy (buff, "ERROR", 5);
        memset (&buff[5], 0x00, 39);
        sprintf (&buff[5], "'%8.8s' registed.", pnt->xmit_callsign);
        sendto (multi_sd, buff, 44, 0,
                (struct sockaddr *)&pnt->multi_addr, sizeof(struct sockaddr));
}

void	send_disconnect_hole_punch (void)
{
	struct	area_callsign	*ar_temp;
	unsigned char	hole_punch[24];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;
	char	temp[10];
	char	*pnt;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	memset (PORT, 0x00, 10);
	sprintf (PORT, "%d", hole_punch_port);
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				ar_temp = ar_callsign_pnt;
				while (ar_temp)
				{
        				memset (hole_punch, 0x00, sizeof(hole_punch));
					memcpy (hole_punch, "DISC", 4);
        				memcpy (&hole_punch[4], ar_temp->ar_callsign, 8);
        				hole_punch[12] = (multi_port >> 8) & 0xff;
        				hole_punch[13] = multi_port & 0xff;
					memset (temp, 0x00, sizeof(temp));
					memcpy (temp, VERSION, strlen(VERSION));
					pnt = strtok(temp, ".");
					hole_punch[14] = atoi(pnt) & 0xff;
					pnt = strtok(NULL,".");
					hole_punch[15] = atoi(pnt) & 0xff;
					memcpy (&hole_punch[16], zr_callsign, 8);
					//hole_punch[23] = 0x20;
        				ret = sendto(multi_sd, hole_punch, 24, 0, 
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s disconnect_hole_punch error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					ar_temp = ar_temp->next;
				}
				break;		/* new version test */
			}
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_disconnect_hole_punch) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void	position_update(char call[], char ar_call[])
{
	char	buff[26];
	int	ret;
	time_t	atime;

	memset (buff, 0x20, 26);
	memcpy (buff, "DSTR", 4);
	buff[4] = (fwd_send_seq >> 8) & 0xff;
	buff[5] = fwd_send_seq & 0xff;
	fwd_send_seq++;
	fwd_send_seq &= 0xffff;
	buff[6] = 's';
	buff[7] = 0x21 | GW;
	buff[8] = 0x00;
	buff[9] = 0x10;
	memcpy (&buff[10], call, 8);
	memcpy (&buff[18], ar_call, 8);

        ret = sendto (fwd_sd, buff, 26, 0,
        	(struct sockaddr *)&fwd_addr, sizeof(fwd_addr));
        if (ret == -1)
        {
        	time(&atime);
                fprintf (log_file, "%24.24s mult->fwd error %s\n", 
			ctime(&atime), strerror(errno));
                fflush (log_file);
        }
}

