package PluginManager::Installed;
use strict;

use MT::Object;
use base qw( MT::Object );
@PluginManager::Installed::ISA = qw( MT::Object );
__PACKAGE__->install_properties({
		column_defs => {
			'id' => 'integer not null auto_increment',
			'signature' => 'string(255) not null',
			'version' => 'string(255) not null',
			'files' => 'text not null',
			'control' => 'text not null',
			'script' => 'blob not null',
		},
		indexes => {
			signature => 1,
			version => 1,
		},
		primary_key => 'id',
		datasource => 'pm_installed',
		audit => 1,
	});
1;

sub make_control_locale {
	my $self = shift;
	my ($locale) = @_;

	require YAML::Tiny;
	my $yaml = YAML::Tiny->read_string($self->control);

	$yaml->[0]{$locale} || $yaml->[0]{'en-us'};
}
