/**********************************************************/
/*! @addtogroup MRM3DPlugin 
    @file       MRM3DPeakDetector.h
    @brief      Filter Parser Functions Header
    @date       2012.10.24
	@author     M.Fukuda
	@version    1.0.0
	
	Copyright(C) 2006-2013 Eisai Co., Ltd. 
	                       All rights reserved.
 **********************************************************
2012.10.24
MRM3D Peak Picking̃CNX
*/
/**********************************************************/
#pragma once

// O錾
namespace mspp{
	namespace sprt{
		class PeakDetector;
		class PeakSmoother;
	}
}

namespace kome{
namespace mrm3d{
	
class MRMChromKeeper;
class MRMChrom;
class ParamParser;

/*!--------------------------------------------------------
    @name   MRM3DCore
    @breif 	MRM3DPeakPicking main Class
	@date   2012.10.23
	@par	ChromatogramƂMRMf[^𒊏o
	        Smoothing, Peak Picking, FilteringsA
			Peaks2d@Ƃā@ʂԂB
-----------------------------------------------------------*/
class MRM3DCore {

private:
	/*! @emum
	 *  @brief MRM3D Step Number
	 */
	enum MRM3DStep {
		CONVERT,   // Convert step
		PEAKPICK,  // PeakPicking step
		STEP_NUM,
	};
	/*! type def */
	typedef std::shared_ptr<MRMChrom> tMRMChromPtr;
	typedef std::vector<tMRMChromPtr> tvMRMPtr; /* t(ypedef) v(ector) ̐ړ*/

	/*! my Parameters*/
	kome::objects::SettingParameterValues* m_settings;
	ParamParser* m_parser;

public:
	explicit MRM3DCore( kome::objects::SettingParameterValues* settings );
	~MRM3DCore();
private:
	// copy̗ދ֎~Eh~
	MRM3DCore(const MRM3DCore& m) {}
	MRM3DCore& operator=(const MRM3DCore& rhs){}

public:
	/*!
	 * @brief execute mrm3d Peak Picking
	 * @param[in]  kome::objects::DataSet& dataSet Objects
	 * @param[in]  kome::core::Progress& progress objects pointer
	 * @param[out] kome::objects::Peaks2D& results 2D Peaks
	 */
	void executeLabeling (
		kome::objects::DataSet& dataSet,
		kome::core::Progress& progress,
		kome::objects::Peaks2D& peaks);

private:

	/*!
	 * @brief check having mrm filter infomations.
	 * @param[in]  kome::objects::DataSet& dataSet Objects
	 * @retval true Is Having MRM Infomation
	 * @note check spectrum[0] having filter info only.
	 */
	const bool isHavingMRMType (kome::objects::DataSet& dataSet);

	/*!
	 * @brief get MRMData From DataObjects
	 * @param[in]  kome::objects::DataSet& Tṽf[^Zbg
	 * @param[in]  kome::core::Progress& @getMRMDatatF[ỸvOX|C^
	 * @param[out] std::vector<std::shared_ptr<MRMChrom>> MRMData擾ʂMRMChromz
	 * @retval true Success get MRM Infomation
	 * @par  espectrumoAMRMChromɃf[^WςiL֐ōs)
	 *       MRMChrom̔zƂĕԂB
	 */
	const bool getMRMDatas (
		kome::objects::DataSet& dataSet,
		kome::core::Progress& progress,
		tvMRMPtr& allChroms);

	/*!
	 * @brief divide xydata to any MRMchroms
	 * @param[in]     kome::objects::Spectrum* : parse Spectrum
	 * @param[in out] MRMChromKeeper*& : set MRMChrom XYData from Spectrum
	 * @par MRMChromKeeper̊eMRMChrom@Q3@͈͓̔
	 *      Spectrum XYDatåY|CgΘaZB
	 *      eMRMChrom SpecRT : X, Q3͈͓̍v intensity : Y ƂȂB
	 */
	void divideXYDataPoints (
		kome::objects::Spectrum* spectrum,
		MRMChromKeeper*& stocker);

	/*!
	 * @brief Detect Chromatgram Peaks
	 * @param[in]  std::shared_ptr<MRMChrom>&
	 * @param[in]  mspp::sprt::PeakDetector*
	 * @param[in]  mspp::sprt::PeakSmoother*
	 * @param[out] kome::objects::Peaks2D& results 2D Peaks
	 * @par MRMChromXYData\A
	 *      Smoothing, PeakPickings 
	 *      Peaks2DɌʂǉB
	 */
	void detectAndConvertPeaks (
		tMRMChromPtr& chromPtr,
		mspp::sprt::PeakDetector* pkFunc,
		mspp::sprt::PeakSmoother* pksmth,
		kome::objects::Peaks2D& peaks2d);

	/*!
	 * @brief convert from MRMChromData to xydata
	 * @param[in]  std::shared_ptr<MRMChrom>&
	 * @param[out] kome::core::XYData*
	 * @retval true Success convert
	 * @note Mass++Pluginsmoothing,PeakPickׁA
	 *       W̃f[^`ɃRo[gB
	 */
	const bool convertToXYData (
		tMRMChromPtr& chromPtr,
		kome::core::XYData* xydata);

	/*!
	 * @brief convert from Peaks to Peaks2D
	 * @param[in]  std::shared_ptr<MRMChrom>&
	 * @param[in]  kome::core::XYData&
	 * @param[out] kome::objects::Peaks2D& results 2D Peaks
	 * @retval true Success convert
	 * @note Peaks(ʂ̌)@Q1,Q3̏
	 *       2DPeaks̃f[^`ɃRo[gB
	 */
	const bool convertTo2DPeaks (
		tMRMChromPtr& chromPtr,
		kome::objects::Peaks& tmpPeaks,
		kome::objects::Peaks2D& peaks2d);

	/*!
	 * @brief convert from Peaks to Peaks2D
	 * @param[in-out] kome::objects::Peaks2D& results 2D Peaks
	 * @retval true Success Filtered
	 */
	const bool FilterPeak2D (
		kome::objects::Peaks2D& peaks2d);

};


}
}
