/*********************************************************/
/*!
 @addtoGroup AB3D
 @file TempTableCtrl.h
 @brief Temp Table Accesser Base
 
 @date 2013.07.01
 @author M.Fukuda
 @varsion 1.0.0

 -------------------------------------------------------
 Copyright(C) 2006-2014
 Eisai Co., Ltd. All rights reserved.
 -------------------------------------------------------
 @note
   Peak PositionɂAAB3Dł̌ʂ
   ۑAǂݏo߂̃e[u쐬
 */
/*********************************************************/
#pragma once

// O錾
namespace AB3D {
	class DbAccess;
	struct TmpPeakVal;
	struct TmpMXVal;
}

namespace AB3D {

/*!--------------------------------------------------------
    @name   TmpTblCtrl
    @brief  AB3ĎʂꎞۊǂTempTablȇ
    @date   2013.07.01
    @par    TempTablëȂS
-----------------------------------------------------------*/
	class TmpTblCtrl {
		
	public:
		// constructor
		TmpTblCtrl();
		// destructor
		~TmpTblCtrl();

	private:
		// Uncopyable
		TmpTblCtrl(const TmpTblCtrl&);
		TmpTblCtrl& operator=(const TmpTblCtrl&);

	private:
		std::unique_ptr<DbAccess> ptr_;

		// STMT쐬ĕێĂB
		// j[N|C^ŊǗ̂ŁAj͎IɂB
		// // Tempe[uւ̃CT[g(Set)
		std::unique_ptr<kome::db::Statement> stmt_tmpPeak_;
		std::unique_ptr<kome::db::Statement> stmt_tmpVal_;
		std::unique_ptr<kome::db::Statement> stmt_tmpProf_;

		// // Tempe[uւ̃Abvf[g
		std::unique_ptr<kome::db::Statement> stmt_UpdtCrg_;

		// // Tempe[u Select(Get)
		std::unique_ptr<kome::db::Statement> stmt_SlctVal_;
		std::unique_ptr<kome::db::Statement> stmt_SlctProf_;

	public:
		const int createTempTable();

		const bool createTempStatements();

		// e[u֐BDBAccessɊ֐Ƃēn
		static void createTempTableAB3DPeak(kome::db::Table& table, const char* tname);
		static void createTempTableAB3DVal(kome::db::Table& table, const char* tname);
		static void createTempTableAB3DProf(kome::db::Table& table, const char* tname);

		// XYBufferTmpɋL^B͂OȏID߂
		const int setXYBuffer(kome::core::Buffer* buffer);

		// Temp Matrix Value Insert
		const int setTmpMXValue(
			const int sampleid,   
			const int bufid,
			const double peak_x,  
			const double peak_y,
			const double left_x,  
			const double left_y,
			const double right_x, 
			const double right_y,
			const double value
			);

		// Temp Peak Insert
		const int setTmpPeak(
			const int sampleid,
			const int mxvid,
			const double rt,
			const double mz
			);

		// OXYBuffero
		const bool getXYBuffer(
			const int bufId,
			kome::core::Buffer& refBuffer
			);

		// Tempɓfo LȒl݂̂擾
		const bool getTemporaryDatas(
			std::vector<TmpPeakVal*>& refTmpPeakVals);

		// Temp Peak ́@ChargeUpdate.
		void updateCharge(const int peakId, const int charge);

		void closeMe();

	private:
		// InsertStmt̐BxĂׂĎg܂킷B
		const bool onCreateStmt_Insert_TmpPEAKS();
		const bool onCreateStmt_Insert_TmpMXVALUES();
		const bool onCreateStmt_Insert_TmpPROFILES();

		// UpdateStmt̐BxĂׂĎg܂킷B
		const bool onCreateStmt_UpdateCharge();

		// SelectStmt̐BxĂׂĎg܂킷B
		const bool onCreateStmt_SelectTmpMXVALUES();
		const bool onCreateStmt_SelectTmpPROFILES();

		//BUFFERTEMPTABLEɓo^B
		const bool onDoInsertBuffer(kome::core::Buffer* buffer);

		// Temp Profile e[u̍ŐVID擾
		const int onGetMaxID_TmpPROFILES();

		//MatrixValueTEMPTABLEɓo^B
		const bool onSetTmpMXValue(
			const int sampleid,
			const int bufid,
			const double peak_x,
			const double peak_y,
			const double left_x,
			const double left_y,
			const double right_x,
			const double right_y,
			const double value
			);
		
		// Temp Matrix Value e[u̍ŐVID擾
		const int onGetMaxID_TmpMXVALUES();

		//PeakValueTEMPTABLEɓo^B
		const bool onSetTmpPeak(
			const int sampleid,
			const int mxvid,
			const double rt,
			const double mz
			);

		// TempPeake[u̍ŐVID擾
		const int onGetMaxID_TmpPEAKS();

		// ʎ擾pSQL\ĕԂ
		const std::string onCreateSQL_TempResults();

		const bool onGetTmpMXValue(
			const int mxvId,
			TmpMXVal& refMxval
			);


	};

}
