/**
 * @file SampleTreeBuilderManager.h
 * @brief interfaces of sample tree builder manager functions
 *
 * @author okada_h
 * @date 2012.09.28
 * 
 * Copyright(C) 2006-2014 Shimadzu Corporation All rights reserved.
 */

#ifndef __KOME_SAMPLE_TREE_BUILDER_MANAGER_H__
#define __KOME_SAMPLE_TREE_BUILDER_MANAGER_H__


namespace kome{
	namespace SampleTreeBuilder{
		
		class SampleTreeBuilderManager{
		protected:
			/**
			 * @fn SampleTreeBuilderManager()
			 * @brief constructor
			 */
			SampleTreeBuilderManager();

			/**
			 * @fn virtual ~SampleTreeBuilderManager()
			 * @brief destructor
			 */
			virtual ~SampleTreeBuilderManager();

		private:
			// ݃VXeɂ SampleTreeBuilderSampleSet* ̈ꗗBeXRXgN^this|C^o^Adestructorœo^
			std::set< kome::SampleTreeBuilder::SampleTreeBuilderSampleSet* > m_setSsPtrs;

		public:
			/**
			 * @fn void registPtr( kome::SampleTreeBuilder::SampleTreeBuilderSampleSet* ptr )
			 * @brief SampleTreeBuilderSampleSet* newہȀĂяoAIuWFNg̃|C^o^
			 * @param ptr
			 */
			void registPtr( kome::SampleTreeBuilder::SampleTreeBuilderSampleSet* ptr ){
				if( m_setSsPtrs.find( ptr ) == m_setSsPtrs.end() ){
					// o^ĂȂ
					m_setSsPtrs.insert( ptr );	// o^
				}
			}

			/**
			 * @fn void unregistPtr( kome::SampleTreeBuilder::SampleTreeBuilderSampleSet* ptr )
			 * @brief SampleTreeBuilderSampleSet* jہȀĂяoAIuWFNg̃|C^̓o^
			 * @param ptr
			 */
			void unregistPtr( kome::SampleTreeBuilder::SampleTreeBuilderSampleSet* ptr ){
				if( m_setSsPtrs.find( ptr ) == m_setSsPtrs.end() ){
					// o^ĂȂ
				}else{
					m_setSsPtrs.erase( ptr );	// o^
				}
			}

		public:

			/**
			 * @fn static SampleTreeBuilderManager& getInstance()
			 * @brief gets SampleTreeBuilderManager object
			 * @return SampleTreeBuilderManager object. (This is the only object.)
			 */
			static SampleTreeBuilderManager& getInstance();
		};
	}
}

using namespace kome::SampleTreeBuilder;


#endif
