/**
* @file FileSampleReader.cpp
* @brief File Sample Reader
* @author OKADA, H.
* @date 2012/07/20
* Copyright (C) 2014 Shimadzu Corporation All rights reserved.
* <⑫>
*/

#include "stdafx.h"
#include "FileSampleReader.h"
#include "FileIOPluginOperation.h"


using kome::io::FileSampleReader;



// constructor
FileSampleReader::FileSampleReader(){
}


// destructor
FileSampleReader::~FileSampleReader(){
}


// RawDataFile _CAOJt@CpX1ȏIBeX̃L[t@CpXƂB
std::string FileSampleReader::onSelectKeys( void ){
//	RawDataFileDialog

	std::string strFilePaths = "";

	kome::window::RawDataFileDialog dlg( kome::window::WindowTool::getMainWindow() );
	if( dlg.ShowModal() == wxID_OK ) {
		for( unsigned int i = 0; i < dlg.getNumberOfPaths(); i++ ) {
			if( i == 0 ){
				strFilePaths  = "";
			}else{
				strFilePaths += STR_FILE_STRINGS_SEPARATOR;	// 2ڈȍ~SEPARATORŋ؂
			}

			std::string strTemp = dlg.getPath( i );
			strFilePaths += strTemp;
		}
	}

	return strFilePaths;
};


// L[t@CpXƂăTv擾B
kome::objects::Sample* FileSampleReader::onOpenData( std::string strKey ){	// strKeyɂfile path1

	// path
	std::string fileName;
	fileName = getfilename( strKey.c_str() );
		
	wxBeginBusyCursor();

	// Operation 쐬
	FileIoOperation* opt = new FileIoOperation();
	opt->setOperationType( kome::operation::Operation::TYPE_INPUT );
	opt->setShortName( "file_open" );
	opt->setOperationName( "File Open" );

	opt->setFilePath( strKey.c_str() );

	if( opt->execute() ){
		wxEndBusyCursor();
		return opt->getTargetSample();
	}else{
		delete opt;
	}

	wxEndBusyCursor();

	return 0;
};
