/**
 * @file DBAccessClass
 * @brief Data Processing List Box Informations
 *
 * @author M.Fukuda
 * @date 2013.02.26
 *
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 *
 * @ note -=====================================
 *     Link DB̒l𓝊B
 *     (has-a) DBACCSelectDialog : ĨR{{bNX
 */

#pragma once

#include <string>
#include <vector>

namespace kome {
	namespace massbank {
		namespace wizard {

			//-----------------------------------------------
			//  DB Access Class
			//-----------------------------------------------
			class DBAccClass {
				// DB Links̏
				struct DBLinks {
					std::string dbName;  //DB (CASƂj
					std::string URLHead; //URL̐擪 (ACCSESSION̑O)
					std::string URLTail; //URĽ㔼 (ACCSESSIOŇ)
					std::string URL;     //fURL

					// constructor
					DBLinks(
						const std::string& d,
						const std::string& h,
						const std::string& t
						) : dbName(d), URLHead(h), URLTail(t){}
					
					void setURL(const std::string& acc) {
						URL = URLHead + acc + URLTail;
					}
				};
			public:
				// constructor
				DBAccClass();
				// destructor
				~DBAccClass(){}

			private:
				// DB Link̍\̌Q
				std::vector<DBLinks> DBLArr_;
				std::vector<kome::ident::ExternalDB*> extDbs_;
				void init();

				std::string searchedKeyword_;

			public:
				// i[ĂDB Link̏񐔂Ԃ
				unsigned int getMyNum()const{return DBLArr_.size();}

				// ΏIDDBԂiString)
				std::string getNames(const unsigned int idx) const;

				// ΏIDDBԂiconst char*)
				const char* getName(const unsigned int idx) const;

				// demo URLԂ(String)
				std::string getsURL(const unsigned int idx) const;

				// demo URLԂ
				const char* getURL(const unsigned int idx) const;

				// {̃pl DB List̒l󂯎B
				const std::string setListArrStrs(const std::string& listStr);

				const bool callSearchKeyWordtoExDB(
					std::string& searchedKeyword,
					std::vector<std::string>& results);

				const bool getKeyWordSearchResults(
					std::string& rstName,
					std::string& linksVal,
					std::string& accURL
					);

			private:
				const std::string getURL(
					const std::string& exdb,
					const std::string& accession);

			};

		}
	}
}
