ActionController::Routing::Routes.draw do |map|
  # The priority is based upon order of creation: first created -> highest priority.

  # Sample of regular route:
  #   map.connect 'products/:id', :controller => 'catalog', :action => 'view'
  # Keep in mind you can assign values other than :controller and :action

  map.with_options  :controller => 'reports', :action => 'index' do |m|
    m.connect 'reports/:year/:month/:day', :year => /\d{4}/, :month => /\d{2}/, :day => /\d{2}/
    m.connect 'reports/:year/:month/:day.:format', :year => /\d{4}/, :month => /\d{1,2}/, :day => /\d{1,2}/
  end
  map.with_options :controller => 'reports', :action => 'range' do |m|
    m.connect 'reports/:range', :range => /\d{8}-\d{8}/
    m.connect 'reports/:range.:format', :range => /\d{8}-\d{8}/
    m.connect 'reports/range'
  end

  # Sample of named route:
  #   map.purchase 'products/:id/purchase', :controller => 'catalog', :action => 'purchase'
  # This route can be invoked with purchase_url(:id => product.id)

  map.help 'help', :controller => 'helps', :action => 'index'
  map.settings 'settings', :controller => 'settings', :action => 'index'
  map.answer 'problems/answer', :controller => 'problems', :action => 'answer'

  # Sample resource route (maps HTTP verbs to controller actions automatically):
  #   map.resources :products

  map.resources :reports, :only => [:show]

  # Sample resource route with options:
  #   map.resources :products, :member => { :short => :get, :toggle => :post }, :collection => { :sold => :get }

  # Sample resource route with sub-resources:
  #   map.resources :products, :has_many => [ :comments, :sales ], :has_one => :seller

  # Sample resource route with more complex sub-resources
  #   map.resources :products do |products|
  #     products.resources :comments
  #     products.resources :sales, :collection => { :recent => :get }
  #   end

  # Sample resource route within a namespace:
  #   map.namespace :admin do |admin|
  #     # Directs /admin/products/* to Admin::ProductsController (app/controllers/admin/products_controller.rb)
  #     admin.resources :products
  #   end

  map.namespace :admin do |admin|
    admin.resources :affiliations
    admin.connect 'users/delete', :controller => 'users', :action => 'destroy_selected', :conditions => { :method => :delete }
    admin.resources :users
    admin.connect('units/sort',
                  :controller => 'units', :action => "sort",
                  :conditions => { :method => :post })
    admin.resources :units
    admin.resources :problems
    admin.connect('problem_groups/sort',
                  :controller => 'problem_groups', :action => 'sort',
                  :conditions => { :method => :post })
    admin.resources :problem_groups
  end

  map.resource :user, :only => [:show, :edit, :update]

  # You can have the root of your site routed with map.root -- just remember to delete public/index.html.
  # map.root :controller => "welcome"
  map.root :controller => "home"

  # See how all your routes lay out with "rake routes"

  # Install the default routes as the lowest priority.
  # Note: These default routes make all actions in every controller accessible via GET requests. You should
  # consider removing or commenting them out if you're using named routes and resources.
  map.connect ':controller/:action/:id'
  map.connect ':controller/:action/:id.:format'
end
