name 'hadoop-pleiades'
description 'Pleiades Hadoop cluster node'

run_list(
  # LDAP (option)
  #'role[nameservice-client-grid]',
  'role[hadoop]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

grid_vol_root = '/grid/vol'
hadoop_attributes = {
  # core-site.xml
  'this.cluster.name' => 'pleiades', 
  'this.domain' => 'grid.example.com',
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint",
  #'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint",
  # hdfs-site.xml
  'this.secondary.namenode.fqdn' => '${this.cluster.name}-cn.${this.domain}',
  'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name",
  #'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name",
  'dfs.replication' => '2',
  #'dfs.replication' => '3',
  # mapred-site.xml
  'this.jobtracker.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  'this.jobhistory.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  #'this.jobhistory.fqdn' => '${this.cluster.name}-jh.${this.domain}',
}

default_attributes(
  'grid' => {
    'vol_root' => grid_vol_root,
    'max_vol_nums' => '4'
  },
  'hadoop' => hadoop_attributes
)

#override_attributes "apache2" => { "max_children" => "50" }
