#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

cluster_name = 'ptolemy'
cluster_sym = cluster_name.to_sym
datanode_prefix = 'dn4'
datanode_digit_nums = '4'

name "#{cluster_name}-dn"
description "#{cluster_name.capitalize} DataNode node"

run_list(
  'role[node_commons]',
  #'role[grid-realm]',
  'role[ganglia-gmond]',
  "role[#{cluster_name}-node]"
)

#env_run_lists()

mcast_addr = Grid::CLUSTERS[cluster_sym][:datanodes][:mcast_addr]
port = '8649'

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'DataNode00000',
      'owner' => Grid::DOMAIN
    },
=begin
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
    }
=end
    ## automatic multi/uni-cast
    'gmond_conf_type' => 'automatic',
    'automatic' => {
      'cluster_name_prefix' => 'DataNode', # DataNode#####
      'cast_mode' => 'uni',                # or multi
      'domain' => Grid::DOMAIN,
      #'node_prefix' => 'dn',
      'node_prefix' => datanode_prefix,
      #'digit_nums' => '5',                 # dn#####
      'digit_nums' => datanode_digit_nums,  # dn4####
      'padstr' => '0',           # dn00000
      'first_node_num' => '0',   # 1st node:  dn00000.grid.example.com
      #'last_node_num'  => '999', # last node: dn00999.grid.example.com
      'last_node_num'  => '1', # last node: dn40001.grid.example.com
      'head_node_nums' => '2',   # heads of the 1st cluster: dn0000{0..1}.grid.example.com
      'cluster_size' => '40',    # heads of the 2nd cluster: dn0004{0..1}.grid.example.com
      'host_format' => 'fqdn',   # fqdn/ip (uni-cast mode only)
      'mcast_join' => mcast_addr, # multi-cast mode only
      'port' => port,
      'ttl' => '1',              # multi-cast mode only
      'bind' => mcast_addr       # multi-cast mode only
    }
  }
)
