name 'docker-registry'
description 'Docker Registry'

run_list(
  'recipe[ssl_cert::ca_certs]',
  'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[docker-grid::registry]',
)

#env_run_lists()

#default_attributes()

registry_cn = 'registry.docker.example.com'

override_attributes(
  'docker-grid' => {
    'registry' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => registry_cn,
      },
      'docker-compose' => {
        'config' => {
          'registry' => {
            'restart' => 'always',
            'image' => 'registry:2',
            'ports' => [
              '5000:5000',
            ],
            'environment' => {
              # These environment variables will be set by the docker-grid::registry recipe automatically.
              #'REGISTRY_HTTP_TLS_CERTIFICATE' => '/certs/domain.crt',
              #'REGISTRY_HTTP_TLS_KEY' =>         '/certs/domain.key',
              'REGISTRY_AUTH' =>                'htpasswd',
              'REGISTRY_AUTH_HTPASSWD_PATH' =>  '/auth/.htpasswd',
              'REGISTRY_AUTH_HTPASSWD_REALM' => 'Registry Realm',
            },
            'volumes' => [
              '/var/lib/docker-registry:/var/lib/registry',
              # These volumes will be set by the docker-grid::registry recipe automatically.
              #"#{server_cert_path(node['docker-grid']['registry']['ssl_cert']['common_name'])}:/certs/domain.crt:ro",
              #"#{server_key_path(node['docker-grid']['registry']['ssl_cert']['common_name'])}:/certs/domain.key:ro",
              './auth:/auth',
            ],
          },
        },
      },
    },
  },
  'ssl_cert' => {
    'ca_names' => [
      'grid_ca',
    ],
    'common_names' => [
      registry_cn,
    ],
  }
)

