pig Cookbook
============

This cookbook sets up Apache Pig.

Requirements
------------

#### packages
- `grid` - local cookbook.
- `java` - community cookbook.

Attributes
----------

#### pig::default
|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['pig']['install_flavor']`|String|install flavor.|`'apache'`|
|`['pig']['version']`|String|Pig version.|`'0.12.0'`|
|`['pig']['archive_url']`|String|archive file download URL.|`'http://archive.apache.org/dist/pig'`|
|`['pig']['PIG_PREFIX']`|String|Pig installed path's prefix.|`"#{node['grid']['app_root']}/pig"`|
|`['pig']['HADOOP_HOME']`|String|Hadoop home directory|`"#{node['hadoop']['HADOOP_PREFIX']}"`|
|`['pig']['HADOOP_CONF_DIR']`|String|Hadoop configuration files' directory.|`'${HADOOP_HOME}/conf'`|
|`['pig']['extra_configs']`|Array|Pig extra configurations.|refer to attributes/default.rb|

Usage
-----
#### pig::default

Just include `pig` in your node's `run_list`:

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[pig]"
  ]
}
```

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2015, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
