#
# Copyright 2013,2014 whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

name 'grid-ftp'
description 'Grid distribution node'

run_list(
  'role[node_commons]',
  'role[apt-mirror]',
  'role[apt-cacher-ng]',
  'role[apt-source]',
  'role[yum-mirror]',
  #'role[yum-repos]',
  'role[yum-cdh]',
  'role[cdh-mirror]',
  'role[yum-hdp]',
  'role[hdp-mirror]',
  'role[apache-mirror]',
  #'role[ganglia-gmond]',
)

#env_run_lists()

this_subcluster = Grid::CLUSTERS[:base][:admins]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

default_attributes(
)

override_attributes(
  'apache_utils' => {
    'mirror' => {
      'cron_period' => '5 23   * * *'
    }
  },
  'apt_utils' => {
    'source' => {
      'apt_lines' => [
        '#deb http://cdn.debian.net/debian wheezy main contrib non-free',
        '#deb http://cdn.debian.net/debian wheezy-updates main contrib',
        '#deb http://cdn.debian.net/debian wheezy-backports main contrib non-free',
        '#deb http://security.debian.org/ wheezy/updates main contrib non-free',
        # self test
        'deb http://ftp.grid.example.com/debian wheezy main contrib non-free',
        'deb http://ftp.grid.example.com/debian wheezy-updates main contrib',
        'deb http://ftp.grid.example.com/debian wheezy-backports main contrib non-free',
        'deb http://ftp.grid.example.com:3142/security.debian.org/ wheezy/updates main contrib non-free'
      ]
    },
    'mirror' => {
      'cron_period' => '5 22   * * *',
      'country' => 'jp',
      'distributions' => {
        'debian' => {
          'code_names' => [
            'wheezy',
            'wheezy-updates',
            'wheezy-backports',
            'squeeze',
            'squeeze-updates',
            'squeeze-backports',
          ],
          'architectures' => [
            'amd64',
            'i386'
            #'src',
          ],
          'components' => [
            'main',
            'contrib',
            'non-free'
          ]
        }
      }
    }
  },
  'cdh' => {
    'version' => '4.4.0',
    'yum_repo' => {
      'with_gplextras' => true,
      'update' => true,
      'only_for_mirroring' => true,
      'mirroring' => {
        'platform' => 'centos',
        'platform_version' => '6',
        'arch' => 'x86_64'
      }
    },
    'yum_mirror' => {
      'cron_period' => '5 20   * * *',
      'repo_ids' => [
        'cloudera-cdh4',
        'cloudera-gplextras4',
      ],
      'arch' => 'x86_64',
      'url_alias_with_authority_part' => true
    }
  },
  'hdp' => {
    'version' => '1.3.2',
    #'version' => '1.2.3.1',
    'yum_repo' => {
      'update' => true,
      'only_for_mirroring' => true,
      'mirroring' => {
        'platform' => 'centos',
        'platform_version' => '6'
      }
    },
    'yum_mirror' => {
      'cron_period' => '35 20   * * *',
      'repo_ids' => [
        'HDP-1.x',
        'Updates-HDP-1.x',
        'HDP-UTILS-1.1.0.16',
        'ambari-1.x',
        'Updates-ambari-1.2.5.17'
      ],
      'url_alias_with_authority_part' => true
    }
  },
  'yum_utils' => {
    'repos' => {
      'CentOS-Base' => {
        'mirrorlist_ctx' => '', # default: inactive
        #'mirrorlist_ctx' => 'http://mirrorlist.centos.org',
        'baseurl_ctx' => '',  # default: inactive
        #'baseurl_ctx' => 'http://mirror.centos.org/centos',
        #'baseurl_ctx' => 'http://ftp.grid.example.com/centos',
        'gpgkey' => 'file:///etc/pki/rpm-gpg/RPM-GPG-KEY-CentOS-6'
      },   
      'epel' => {
        'mirrorlist_ctx' => '', # default: inactive
        #'mirrorlist_ctx' => 'http://mirrors.fedoraproject.org',
        'baseurl_ctx' => '',  # default: inactive
        #'baseurl_ctx' => 'http://ftp.grid.example.com/fedora/epel',
        'gpgkey' => 'file:///etc/pki/rpm-gpg/RPM-GPG-KEY-EPEL-6'
      }
    },
    'mirror' => {
      'cron_period' => '5 21   * * *',
      'rsync_sources' => [
        {
          # CentOS
          'url' => 'rsync://ftp.riken.jp/centos/',
          # 5.9 or later
          'rsync_opts' => '-avSH --stats --partial --delete --safe-links --exclude /[1-4]*/ --exclude /5.[0-8]/ --exclude /6.[0-3]/ --exclude local* --exclude isos --exclude ppc*',
          # 6.4 or later
          #'rsync_opts' => '-avSH --stats --partial --delete --safe-links --exclude /[1-5]*/ --exclude /6.[0-3]/ --exclude local* --exclude isos --exclude ppc*',
          'http_alias' => '/centos'
        },
        {
          # EPEL
          'url' => 'rsync://ftp.riken.jp/fedora/epel/',
          # 5 or later
          'rsync_opts' => '-avSH --stats --partial --delete --safe-links --exclude /[1-4]*/ --exclude local* --exclude isos --exclude ppc*',
          # 6 or later
          #'rsync_opts' => '-avSH --stats --partial --delete --safe-links --exclude /[1-5]*/ --exclude local* --exclude isos --exclude ppc*',
          'http_alias' => '/fedora/epel'
        }
      ]
    }
  },
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
