#
# Cookbook Name:: openldap
# Recipe:: server
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node[:platform_family]
  when 'debian'
    [
      'slapd',
      'ldap-utils',
      'ssl-cert',
    ].each {|pkg|
      resources(:package => pkg) rescue package pkg do
        action :install
      end
    }
    
    # for SSL server key access
    group 'ssl-cert' do
      action :modify
      members 'openldap'
      append true
    end

    template "/etc/default/slapd" do
      source  "etc/default/slapd"
      owner 'root'
      group 'root'
      mode '0644'
    end
  when 'rhel'
    [
      'openldap-servers',
      'openldap-clients',
    ].each {|pkg|
      resources(:package => pkg) rescue package pkg do
        action :install
      end
    }

    # for SSL server key access
    if node['openldap']['with_ssl_cert_cookbook'] \
      && node['ssl_cert']['rhel']['key_access_group'] != 'root' then
      group node['ssl_cert']['rhel']['key_access_group'] do
        action :modify
        members 'ldap'
        append true
      end
    end

    template "/etc/sysconfig/ldap" do
      source  "etc/sysconfig/ldap"
      owner 'root'
      group 'root'
      mode '0644'
    end
end

# deploy ldif file for TLS settings.
if node['openldap']['with_ssl_cert_cookbook'] then
  [
    '00_olc-add-ldaps.ldif',
    '00_olc-mod-ldaps.ldif',
  ].each {|ldif|
    template "/etc/ldap/#{ldif}" do
      source  "etc/ldap/#{ldif}"
      owner 'root'
      group 'root'
      mode '0644'
    end
  }
end

service 'slapd' do
  #action [:enable, :start]
  action [:enable]
  supports :status => true, :restart => true, :reload => false
end

log <<-EOM
Note:
You must setup OpenLDAP configurations in the first installation:
  [Debian]
    $ sudo sudo dpkg-reconfigure -plow slapd
  [CentOS]
    edit /etc/openldap/slap.d configurations
    $ sudo service slapd restart
EOM

