#
# Cookbook Name:: commons
# Recipe Spec:: yum-epel_spec
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'commons::yum-epel' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6').
      converge(described_recipe)
  }

  it 'does not include yum-epel recipe.' do
    expect(chef_run_on_debian).to_not include_recipe('yum-epel::default')
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0').
      converge(described_recipe)
  }

  it 'includes yum-epel recipe.' do
    expect(chef_run_on_rhel).to include_recipe('yum-epel::default')
  end
end

