#
# Cookbook Name:: ganglia
# Recipe Spec:: gmetad_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'ganglia::gmetad' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6') {|node|
      node.set['ganglia']['gridname'] = 'Grid'
    }.converge(described_recipe)
  }

  it 'installs gmetad package on debian family.' do
    expected = expect(chef_run_on_debian)
    expected.to install_package('gmetad')
    expected.to enable_service('gmetad')
  end

  it 'renders /etc/ganglia/gmetad.conf on debian family.' do
    expect(chef_run_on_debian).to \
      render_file('/etc/ganglia/gmetad.conf').
        with_content(%r|^gridname\s+Grid$|)
  end

  it 'notifies gmetad service\'s restart after rendering on debian family.' do
    expect(chef_run_on_debian.template('/etc/ganglia/gmetad.conf')).to \
      notify('service[gmetad]').to(:restart).delayed
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0') {|node|
      node.set['ganglia']['gridname'] = 'Grid'
    }.converge(described_recipe)
  }

  it 'installs ganglia-gmetad package on rhel family.' do
    expected = expect(chef_run_on_rhel)
    expected.to install_package('ganglia-gmetad')
    expected.to enable_service('gmetad')
  end

  it 'renders /etc/ganglia/gmetad.conf on rhel family.' do
    expect(chef_run_on_rhel).to \
      render_file('/etc/ganglia/gmetad.conf').
        with_content(%r|^gridname\s+Grid$|)
  end

  it 'notifies gmetad service\'s restart after rendering on rhel family.' do
    expect(chef_run_on_rhel.template('/etc/ganglia/gmetad.conf')).to \
      notify('service[gmetad]').to(:restart).delayed
  end
end

