#
# Cookbook Name:: nexus-grid
# Recipe:: docker-compose
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

::Chef::Recipe.send(:include, SSLCert::Helper)

doc_url = 'https://hub.docker.com/r/sonatype/nexus3/'

include_recipe 'platform_utils::kernel_user_namespace'
include_recipe 'docker-grid::compose'

app_dir = node['nexus-grid']['docker-compose']['app_dir']
data_dir = node['nexus-grid']['docker-compose']['data_dir']
#bin_dir = "#{app_dir}/bin"

[
  app_dir,
  #bin_dir,
].each {|dir|
  resources(directory: dir) rescue directory dir do
    owner 'root'
    group 'root'
    mode '0755'
    recursive true
  end
}

config_srvs = node['nexus-grid']['docker-compose']['config']['services']
override_config_srvs = node.override['nexus-grid']['docker-compose']['config']['services']
#force_override_config_srvs = node.force_override['nexus-grid']['docker-compose']['config']['services']
#envs_org = config_srvs['nexus']['environment']
#envs = {}
vols = config_srvs['nexus']['volumes'].to_a

# Data persistent
resources(directory: data_dir) rescue directory data_dir do
  owner 200
  group 'root'
  mode '0700'
  recursive true
end if !data_dir.nil? && !data_dir.empty?

vols.push("#{data_dir}:/nexus-data") if !data_dir.nil? && !data_dir.empty?

ports = config_srvs['nexus']['ports']
override_config_srvs['nexus']['ports'] = ['8081:8081'] if ports.empty?

if node['nexus-grid']['https_enabled']
  etc_dir = "#{data_dir}/etc"
  resources(directory: etc_dir) rescue directory etc_dir do
    owner 200
    group 200
    mode '0755'
    recursive true
  end

  template "#{etc_dir}/nexus.properties" do
    source 'opt/docker-compose/app/nexus/data/etc/nexus.properties'
    owner 200
    group 200
    mode '0644'
    action :create
  end

  override_config_srvs['nexus']['ports'] = ['8443:8443'] if ports.empty?
end

# merge environment hash
#force_override_config_srvs['nexus']['environment'] = envs unless envs.empty?
# reset vlumes array.
override_config_srvs['nexus']['volumes'] = vols unless vols.empty?

config_file = "#{app_dir}/docker-compose.yml"
template config_file do
  source  'opt/docker-compose/app/nexus/docker-compose.yml'
  owner 'root'
  group 'root'
  mode '0644'
end

log <<-"EOM"
Note: You must execute the following command manually.
  See #{doc_url}
  - Start:
    $ cd #{app_dir}
    $ docker-compose up -d
  - Stop
    $ docker-compose down
EOM
