krb5 Cookbook
=============

This cookbook contains Admin., KDC and Client setup recipes for Kerberos 5.

Requirements
------------

Nothing.

Attributes
----------

#### krb5::default
|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['krb5']['libdefaults']['default_realm']`|String|in /etc/krb5.conf and /etc/kdc.conf|`'LOCALDOMAIN'`|
|`['krb5']['libdefaults']['allow_weak_crypto']`|String|in /etc/krb5.conf|`'false'`|
|`['krb5']['libdefaults']['default_tgs_enctypes']`|String|in /etc/krb5.conf|`nil`|
|`['krb5']['libdefaults']['default_tkt_enctypes']`|String|in /etc/krb5.conf|`nil`|
|`['krb5']['libdefaults']['permitted_enctypes']`|String|in /etc/krb5.conf|`nil`|
|`['krb5']['realms']["#{node['krb5']['libdefaults']['default_realm']}"]['kdcs']`|Array|in /etc/krb5.conf|`['localhost']`|
|`['krb5']['realms']["#{node['krb5']['libdefaults']['default_realm']}"]['admin_setver']`|String|in /etc/krb5.conf|`'localhost'`|
|`['krb5']['domain_realms']`|Array|in /etc/krb5.conf|`['localhost = LOCALDOMAIN']`|
|`['krb5']['kpropd.acl']`|String|ACL setting in /etc/krb5kdc/kpropd.acl|`''`|

Usage
-----
#### recipes
- `krb5::admin` - Admin. and master KDC setup recipe.
- `krb5::client` - Kerberos 5 client setup recipe.
- `krb5::kdc` - slave KDC setup recipe.

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2015, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
