#
# Cookbook Name:: krb5
# Recipe:: admin
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node[:platform_family]
  when 'debian'
    package 'krb5-admin-server' do
      action :install
    end

    service 'krb5-admin-server' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => false
    end

    package 'krb5-kdc' do
      action :install
    end

    service 'krb5-kdc' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => false
    end

    template '/etc/krb5kdc/kdc.conf' do
      source 'etc/krb5kdc/kdc.conf'
      owner 'root'
      group 'root'
      mode '0644'
    end
  when 'rhel'
    package 'krb5-server' do
      action :install
    end

    service 'kadmin' do
      #action [:enable, :start]
      action [:enable]
      supports :status => true, :restart => true, :reload => false
    end
    service 'krb5kdc' do
      #action [:enable, :start]
      action [:enable]
      supports :status => true, :restart => true, :reload => false
    end

    template '/var/kerberos/krb5kdc/kdc.conf' do
      source 'var/kerberos/krb5kdc/kdc.conf'
      owner 'root'
      group 'root'
      mode '0600'
    end
end

log <<-EOM
Note:
You must initialize a Kerberos realm in the first installation:
  [Debian]
    $ sudo krb5_newrealm
    $ sudo service krb5-kdc restart
    $ sudo service krb5-admin-server restart
  [CentOS]
    $ sudo kdb5_util create -s
    $ sudo service kadmin restart
    $ sudo service krb5kdc restart
EOM

