#
# Cookbook Name:: platform_utils
# Library:: VirtUtils
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

module PlatformUtils
  # Virtualization utilities methods
  module VirtUtils
    def container_system?
      case node['virtualization']['system']
      when 'lxc', 'lxd'
        true
      else
        false
      end
    end

    def host_node?
      node['virtualization']['role'] == 'host'
    end

    def guest_node?
      node['virtualization']['role'] == 'guest'
    end

    def container_host_node?
      container_system? && host_node?
    end

    def container_guest_node?
      container_system? && guest_node?
    end
  end
end
