#
# Cookbook Name:: apt_utils
# Recipe Spec:: source_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'apt_utils::source' do
  let(:chef_run_on_non_debian) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0').
      converge(described_recipe)
  }

  it 'does nothing on non debian family.' do
    expect(chef_run_on_non_debian).to_not render_file('/etc/apt/sources.list')
  end

  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '8.1') {|node|
      node.set['apt_utils']['source']['apt_lines'] = [
        'deb http://cdn.debian.net/debian jessie main contrib non-free',
        'deb http://cdn.debian.net/debian jessie-updates main contrib',
      ]
    }.converge(described_recipe)
  }

  it 'renders /etc/apt/sources.list on debian family.' do
    expected = expect(chef_run_on_debian)
    expected.to render_file('/etc/apt/sources.list').
      with_content('deb http://cdn.debian.net/debian jessie main contrib non-free')
    expected.to render_file('/etc/apt/sources.list').
      with_content('deb http://cdn.debian.net/debian jessie-updates main contrib')
  end
end

