#
# Cookbook Name:: docker-grid
# Recipe:: compose
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# See: https://docs.docker.com/compose/install/

include_recipe 'docker-grid::engine'

docker_compose_path = '/usr/local/bin/docker-compose'

execute 'install_docker_compose' do
  user 'root'
  command "curl -L \"#{node['docker-grid']['compose']['release_url']}\" -o #{docker_compose_path} && chmod +x #{docker_compose_path}"
  action :run
  not_if { ::File.exist?(docker_compose_path) } unless node['docker-grid']['compose']['auto_upgrade']
end
