#
# Cookbook Name:: platform_utils
# Library:: Helper
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'shellwords'

module PlatformUtils
  # Helper methods
  module Helper
    def validate_shellwords(words)
      invalid_word = words.find {|word|
        word =~ /[;\|&<>`]/
      }
      unless invalid_word.nil?
        Chef::Log.fatal("Command string includes the invalid character (;|&<>`): #{invalid_word}")
        raise
      end
    end
  end
end
