cdh Cookbook
============

This cookbook provides YUM utility recipes for CDH distribution.

Requirements
------------

#### cookbooks
- yum_utils

#### packages
none.

Attributes
----------

#### cdh::default
|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['cdh']['version']`|String||`'4.3.1'`|
|`['cdh']['archive_url']`|String||`'http://archive.cloudera.com'`|
|`['cdh']['yum_repo']['with_gplextras']`|String|LZO etc. CDH4 only.|`false`|
|`['cdh']['yum_repo']['update']`|String||`false`|
|`['cdh']['yum_repo']['only_for_mirroring']`|String||`false`|
|`['cdh']['yum_repo']['mirroring']['platform']`|String|`'centos'`, `'rhel'`, `'suse'`|`'centos'`|
|`['cdh']['yum_repo']['mirroring']['platform_version']`|String||`'6'`|
|`['cdh']['yum_repo']['mirroring']['arch']`|String|`'i386'`, `'x86_64'`|`'x86_64'`|
|`['cdh']['yum_mirror']['user']`|String|mirroring user|`'yum-mirror'`|
|`['cdh']['yum_mirror']['cron_period']`|String|cron period expression|`'#0 4   * * *'` (inactive)|
|`['cdh']['yum_mirror']['base_path']`|String|base directory path|`'/var/spool/cdh-mirror'`|
|`['cdh']['yum_mirror']['yum_conf']`|String|YUM configuration file path|Debian: `'/etc/yum/yum.conf'`, RHEL: `'/etc/yum.conf'`|
|`['cdh']['yum_mirror']['repos_dir']`|String|repository configuration directory path|Debian: `'/etc/yum/repos.d'`, RHEL: `'/etc/yum.repos.d'`|
|`['cdh']['yum_mirror']['repo_ids']`|Array|mirroring repository ids|`[]` (empty)|
|`['cdh']['yum_mirror']['arch']`|String|system architecture|`'x86_64'`|
|`['cdh']['yum_mirror']['url_alias_with_authority_part']`|Boolean|use url alias with authority part|`true`|

Usage
-----
#### cdh::default
- do nothing.

#### cdh::yum_mirror
- set up mirroring configurations for CDH repository.

#### cdh::yum_repo
- set up YUM repository configurations of CDH.

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
