#
# Cookbook Name:: jenkins-grid
# Attributes:: default
#
# Copyright 2016-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['jenkins-grid']['with_ssl_cert_cookbook'] = false
# If ['jenkins-grid']['with_ssl_cert_cookbook'] is true,
# node['jenkins-grid']['docker-compose']['config']
# are overridden by the following 'common_name' attributes.
default['jenkins-grid']['ssl_cert']['common_name'] = node['fqdn']
default['jenkins-grid']['num_executors'] = 2
default['jenkins-grid']['log.properties'] = {
  'handlers' => 'java.util.logging.ConsoleHandler',
  'jenkins.level' => 'FINEST',
  'java.util.logging.ConsoleHandler.level' => 'FINEST',
}
default['jenkins-grid']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/jenkins"
default['jenkins-grid']['docker-compose']['jenkins_home']['path'] = '/var/lib/jenkins_home'  # on host.
force_override['jenkins-grid']['docker-compose']['jenkins_home']['owner'] = 1000
default['jenkins-grid']['docker-compose']['config'] = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'jenkins' => {
      'restart' => 'always',
      'image' => 'jenkins:latest',
      #'expose' => [
      #  #'8083',  # for https
      #],
      'ports' => [
        #'8080:8080',
        #'8083:8083',
        #'50000:50000',
      ],
      'environment' => {
=begin
        'JAVA_OPTS' => [
          '-Dhudson.footerURL=http://mycompany.com',
          '-Djava.util.logging.config.file=/var/jenkins_home/log.properties',
        ].join(' '),
        'JENKINS_OPTS' => [
          '--httpPort=-1 --httpsPort=8083',
          '--httpsCertificate=/var/lib/jenkins/server.crt',
          '--httpsPrivateKey=/var/lib/jenkins/server.key',
        ].join(' '),
=end
      },
      'volumes' => [
=begin
        # set automatically, if the node['jenkins-grid']['docker-compose']['jenkins_home']['path'] is not nil.
        "#{node['jenkins-grid']['docker-compose']['jenkins_home']['path']}:/var/jenkins_home",
        # These volumes will be set by the concourse-ci::docker-compose recipe automatically.
        "#{server_cert_path(node['jenkins-grid']['ssl_cert']['common_name'])}:/var/lib/jenkins/server.crt:ro",
        "#{node['jenkins-grid']['docker-compose']['app_dir']}/certs/server.key:/var/lib/jenkins/server.key:ro",
=end
      ],
    },
  },
}
