package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import junit.framework.TestCase;

public class DynamicTranslationDictionaryTest extends TestCase {

	/** ターゲット */
	protected final DynamicTranslationDictionary target = new DynamicTranslationDictionary();

	/** assertLookup */
	protected void assertLookup(String input, String expected) {
		String result = target.lookup(input, null);
		System.out.println(input + "=" + result);
		assertEquals(expected, result);
	}

	/** テスト */
	public void testLookup() {

		// 全角混在
		assertLookup("Space ( ・ )", "空白 ( ・ )");
		assertLookup("Ideographic space ( ° )", "全角空白 ( ° )");
		assertLookup("Tab ( ≫ )", "タブ ( ≫ )");
		assertLookup("Carriage Return ( \u00a4 )", "復帰 ( \u00a4 )");
		assertLookup("Line Feed ( ¶ )", "改行 ( ¶ )");

		//「参照 updates」になってしまう ⇒ 正規表現を修正
		assertLookup("Browsing for updates", "更新の参照");
		assertLookup("Browsing for xxx.xxx", "参照 xxx.xxx");
		assertLookup("Browsing for xxx", "Browsing for xxx");
		
		// 辞書にエントリーがあっても末尾 . が 。 になる ⇒ ジェネレータの強制トリム廃止
		assertLookup("Misc.", "その他");
	}
}
