/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * 変換済みクラス・キャッシュです。
 * <p>
 * @author cypher256
 */
public class TransformedClassCache extends AbstractClassCache {

	/** ロガー */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TransformedClassCache.class);

	/** このクラスのシングルトン・インスタンス */
	private static final TransformedClassCache singleton = new TransformedClassCache();

	/**
	 * 変換済みクラス・キャッシュ・オブジェクトを取得します。
	 * <p>
	 * @return 変換済みクラス・キャッシュ・オブジェクト
	 */
	public static TransformedClassCache getInstance() {
		return singleton;
	}

	@Override
	protected File getFile() {
		return new File(Pleiades.getConfigurationPath(), "transformed-class.cache");
	}

	@Override
	protected String getName() {
		return "変換済みクラス・キャッシュ";
	}
}
