/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

import org.apache.commons.io.IOUtils;

/**
 * |vpeB[ɗvfȂꍇ̏o͂邽߂̃vpeB[łB
 * <p>
 * @author cypher256
 */
public class TranslationNotFoundProperties {

	/** K[ */
	private static final Logger log = Logger.getLogger(TranslationNotFoundProperties.class);

	/** ̃OLȂƂVXeEvpeB[̃L[ */
	public static final String NOT_FOUND_PROPERTIES_ENABELD = "pleiades.enabled.not.found.log";

	/** 󖳂Oo̓t@C */
	private static final File NOT_FOUND_LOG_FILE_NAME =
		new File(Pleiades.getConfigurationPath(), "translation-notfound.properties");

	/** 󖳂Oo͂珜OvfXgt@C */
	private static final File EXCLUDE_LIST_FILE =
		FileSystem.getResourceFile("translation-notfound-exclud.list");

	/** 󖳂K[CX^X */
	private static TranslationNotFoundProperties notFoundLog;

	/** 󖳂K[CX^X̏ */
	static {
		String enabled = System.getProperty(NOT_FOUND_PROPERTIES_ENABELD);
		if (Boolean.valueOf(enabled)) {
			notFoundLog = new TranslationNotFoundProperties();
			notFoundLog.init();
		} else {
			notFoundLog = new TranslationNotFoundProperties() {
				@Override
				public void println(String enValueNonMnemonic) {
				}
			};
		}
	}

	/** 󖳂K[o͂珜Ovf̃Zbg */
	private Set<String> excludSet;

	/** 󖳂K[o͂珜Ovf̃ZbgiK\j */
	private Set<Pattern> excludPatternSet;

	/** 󖳂K[ɏo͍ς݂̗vfio͗}~pj */
	private Set<String> loggedSet;

	/** t@C PrintStream */
	private PrintStream out;

	/**
	 * CX^Xł܂B
	 */
	private TranslationNotFoundProperties() {
	}

	/**
	 * 󖳂K[̃CX^X擾܂B
	 * <p>
	 * @return 󖳂K[̃CX^X
	 */
	public static TranslationNotFoundProperties getInstance() {
		return notFoundLog;
	}

	/**
	 * ܂B
	 */
	private void init() {

		excludSet = new HashSet<String>();
		excludPatternSet = new HashSet<Pattern>();
		loggedSet = new HashSet<String>();

		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(EXCLUDE_LIST_FILE));

			for (String line; (line = in.readLine()) != null;) {
				if (!line.startsWith("#")) {
					String str = line.replaceAll("\\\\n", "\n");
					String prefix = "%REGEX%";
					if (str.startsWith(prefix)) {
						Pattern pattern = Pattern.compile(str.replaceFirst(prefix, ""));
						excludPatternSet.add(pattern);
					} else {
						excludSet.add(str);
					}
				}
			}

		} catch (IOException e) {
			String msg = "󖳂Oo͏OXg[hł܂łB";
			Exception ise = new IllegalStateException(msg, e);
			Pleiades.abort(ise);

		} finally {
			IOUtils.closeQuietly(in);
		}

		try {
			out = new PrintStream(
					new BufferedOutputStream(new FileOutputStream(NOT_FOUND_LOG_FILE_NAME)),
					true);

			// VM Vbg_EEtbNƂăt@C PrintStream ̃N[Yo^
			Runtime.getRuntime().addShutdownHook(new Thread() {
				@Override
				public void run() {
					PrintStream out = TranslationNotFoundProperties.getInstance().out;
					IOUtils.closeQuietly(out);
				}
			});

		} catch (IOException e) {
			log.fatal("󖳂OC^[𐶐ł܂łB", e);
		}
	}

	/**
	 * w肳ꂽvfOo͂܂B
	 * <p>
	 * @param enValueNonMnemonic j[jbN܂܂Ȃpꃊ\[X
	 */
	public void println(String enValueNonMnemonic) {

		if (loggedSet.contains(enValueNonMnemonic)) {
			return;
		}
		if (excludSet.contains(enValueNonMnemonic)) {
			return;
		}
		for (Pattern pattern : excludPatternSet) {
			if (pattern.matcher(enValueNonMnemonic).matches()) {
				return;
			}
		}
		loggedSet.add(enValueNonMnemonic);

		String key = UnMnemonicProperties.toPropertyKey(enValueNonMnemonic);
		String value = UnMnemonicProperties.toPropertyValue(enValueNonMnemonic);

		// |󂵂₷悤ɉEӂ̉s͋󔒂ɒu
		value = value.replace("\\r", " ");
		value = value.replace("\\n", " ");

		if (key.matches("(?s).*\\p{Alpha}{2}.*")) {
			out.println(key + "=" + value);
		}
	}
}
