/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.apache.commons.io.IOUtils;

/**
 * t@Cɏo͂郍K[łB
 * <p>
 * @author cypher256
 */
public class FileLogger extends Logger {

	/** OEt@CVXeEvpeB[̃L[ */
	public static final String LOG_FILE_NAME = "pleiades.log.file.name";

	/** t@C PrintStream */
	private static PrintStream out;

	/** t@C PrintStream ̏ */
	static {

		String logFileName = System.getProperty(LOG_FILE_NAME);
		try {
			File logFile = new File(logFileName);
			logFile.getParentFile().mkdirs();
			logFile.delete();
			out = new PrintStream(
					new BufferedOutputStream(new FileOutputStream(logFile)),
					true);

		} catch (FileNotFoundException e) {

			throw new RuntimeException("vpeBɎw肳ꂽ " + LOG_FILE_NAME +
					"=" + logFileName + " słB", e);
		}

		// VM Vbg_EEtbNƂăt@C PrintStream ̃N[Yo^
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				IOUtils.closeQuietly(out);
			}
		});
	}

	/**
	 * t@CEK[\z܂B
	 * <p>
	 * @param clazz NX
	 */
	protected FileLogger(Class<?> clazz) {
		super(clazz);
	}

	/*
	 * ( Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#getOut()
	 */
	protected PrintStream getOut() {
		return out;
	}

	/*
	 * ( Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#error(java.lang.String, java.lang.Throwable)
	 */
	public void error(String message, Throwable e) {
		super.error(message, e);
		System.err.println(message);
		if (e != null) System.err.println(e);
	}

	/*
	 * ( Javadoc)
	 * @see jp.sourceforge.mergedoc.pleiades.log.Logger#fatal(java.lang.String, java.lang.Throwable)
	 */
	public void fatal(String message, Throwable e) {
		super.fatal(message, e);
		System.err.println(message);
		if (e != null) System.err.println(e);
	}
}
