/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.util.HashMap;
import java.util.Properties;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * |󃋁[ɏ]ĖœK܂B
 * <p>
 * @author cypher256
 */
public class Optimizer {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(Optimizer.class);

	/** [EvpeB[̃[h */
	private static final Properties ruleProp = FileSystem.loadProperties(
		FileSystem.getResourceFile("props/rule.properties"));

	/**
	 * RXgN^B
	 */
	public Optimizer() {
	}

	/**
	 * |󃋁[Kp܂B
	 * <p>
	 * @param resultProp [KpvpeB[
	 */
	public void apply(Properties resultProp) {

		for (Entry<?, ?> entry : new HashMap<Object, Object>(resultProp).entrySet()) {

			String en = (String) entry.getKey();
			String ja = (String) entry.getValue();
			String e = en.trim();
			String j = ja.trim();

			// Ɩ󕶂͍̂폜
			if (en.equals(ja)) {
				resultProp.remove(entry.getKey());
				continue;
			}

			//-----------------------------------------------------------------
			// ̓
			//-----------------------------------------------------------------

			// |󃋁[ɂuiFj
			for (Entry<Object, Object> rep : ruleProp.entrySet()) {

				String ng = (String) rep.getKey();
				String ok = (String) rep.getValue();

				if (!ok.equals("") && ja.contains(ng)) {
					ja = ja.replaceAll(ng, ok);
				}
			}

			//-----------------------------------------------------------------
			// Ő󔒍킹
			//-----------------------------------------------------------------
			
			String leading =
				en.matches("\\s+.*") ?
				en.replaceFirst("^(\\s+).+$", "$1") :
				"";
			
			String trailing =
				en.matches(".+?\\s+") ?
				en.replaceFirst("^.+?(\\s+)$", "$1") :
				"";
			
			ja = leading + j + trailing;

			//-----------------------------------------------------------------
			// Ɂu.vꍇ͖󕶖́uBv
			//-----------------------------------------------------------------
			
			if (!e.endsWith(".") && j.endsWith("B")) {
				ja = ja.replaceFirst("B(\\s*)$", "$1");
			}
			
			resultProp.put(en, ja);
		}
	}
}
