/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.concurrent.ExecutorService;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * |󏈗𖄂ߍނ߂̃oCgR[hϊsgXtH[}[łB
 * <p>
 * @author cypher256
 */
public class TranslationTransformer extends AbstractTransformer {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationTransformer.class);

	/** bNEt@C */
	private static final File lockFile = new File(Pleiades.getConfigurationPath(), ".lock");

	/**
	 * |gXtH[}[\z܂B
	 */
	public TranslationTransformer() {
		load();
	}

	/**
	 * |ɕKvȃvpeB[[h܂B
	 */
	protected void load() {
		
		// bNEt@C̏I폜\
		lockFile.deleteOnExit();
		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				unlock();
			}
		});
		
		// 񓯊^XNsT[rX擾
		ExecutorService executorService = Pleiades.getExecutorService();

		// bN
		lock();
		
		// ϊONXLbV[h
		executorService.execute(new Runnable(){
			public void run() {
				ExcludesClassNameCache.getInstance();
			}
		});
		// ϊς݃NXELbV[h
		executorService.execute(new Runnable(){
			public void run() {
				TransformedClassCache.getInstance();
			}
		});
		// |󎫏iLbV̏ꍇj[h
		executorService.execute(new Runnable(){
			public void run() {
				DynamicTranslationDictionary.getInstance();
				
				// bN
				// łԂ邱̃t@CE[hɃbNB
				// ̃t@C̃[hxꍇłB
				unlock();
			}
		});

		// 񓯊^XNsT[rXVbg_E\
		executorService.shutdown();
	}

	/**
	 * oCgR[hϊ܂B
	 * <p>
	 * {@link TranslationEditor |GfB^[} gpAoCgR[hϊ܂B
	 * A{@link ExcludesClassNameCache ϊONXLbV}
	 * ɏNX܂܂ꍇAs܂B
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		// ϊONX̏ꍇ͉Ȃ
		ExcludesClassNameCache excludeList = ExcludesClassNameCache.getInstance();
		if (excludeList.contains(className)) {
			return null;
		}

		// ϊς݃NXELbVꍇ͂Ԃ
		TransformedClassCache classCache = TransformedClassCache.getInstance();
		byte[] cachedBytecode = classCache.get(className);
		if (cachedBytecode != null) {
			return cachedBytecode;
		}

		// oCgR[hɖ|AXyNg𖄂ߍ
		CtClass ctClass = createCtClass(bytecode, protectionDomain);
		byte[] transformedBytecode = transformClass(ctClass);

		// Np̏쐬
		if (transformedBytecode == null) {
			// ϊΏۊȌꍇ́AϊOXgɒǉ
			excludeList.add(className);
		} else {
			// ϊꍇ́Aϊς݃NXELbVɒǉ
			classCache.put(className, transformedBytecode);
		}

		return transformedBytecode;
	}

	/**
	 * NXEIuWFNgɖ|AXyNg𖄂ߍ݂܂B
	 * <p>
	 * @param ctClass ϊΏۃNXEIuWFNg
	 * @return ߍ݌̃oCgR[hBߍݑΏۂłȂꍇ nullB
	 */
	protected byte[] transformClass(CtClass ctClass)
		throws CannotCompileException, NotFoundException, IOException {

		TranslationEditor editor = new TranslationEditor(ctClass);

		// RXgN^[A\bh̕ϊ
		for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {

			// R[hAĂяoҏW
			ctBehavior.instrument(editor);

			// \bhҏW
			editor.editBehavior(ctBehavior);
		}

		// X^eBbNECjVCU[̕ϊ
		CtConstructor ctInitializer = ctClass.getClassInitializer();
		if (ctInitializer != null) {
			ctInitializer.instrument(editor);
		}
		return editor.toBytecode();
	}

	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroy() {

		// bN
		lock();
		try {
			// |vpeB[LbVƂĕۑ
			DynamicTranslationDictionary.getInstance().store();
			
			// ϊς݃NXELbVۑ
			TransformedClassCache.getInstance().store();
			
			// ϊONXLbVۑ
			ExcludesClassNameCache.getInstance().store();
			
		} catch (Exception e) {
			log.error("gXtH[}[̔jŃG[܂B", e);
			
		} finally {
			// bN
			unlock();
		}
	}

	/**
	 * bN܂B
	 * SȃbNT|[g킯ł͂܂B
	 */
	private static void lock() {
		
		final int MAX_WAIT = 15;
		try {
			for (int i = 1; i <= MAX_WAIT && lockFile.exists(); i++) {
				Thread.sleep(1000);
				log.debug("bNҋ@łB(" + i + "/" + MAX_WAIT + " b)");
			}
		} catch (Exception e) {
			log.error("bN҂Ŋ荞݂܂B", e);
		}
		try {
			lockFile.createNewFile();
			log.debug("bN܂B");
		} catch (Exception e) {
			log.error("bNEt@C̍쐬Ɏs܂B", e);
		}
	}
	
	/**
	 * bN܂B
	 * SȃbNT|[g킯ł͂܂B
	 */
	private static void unlock() {
		try {
			lockFile.delete();
			log.debug("bN܂B");
		} catch (Exception e) {
			log.error("bNEt@C̍폜Ɏs܂B", e);
		}
	}
}
