/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import junit.framework.TestCase;

/**
 * 翻訳辞書クラスのテスト・クラスです。
 * <p>
 * @author cypher256
 */
public class TranslationDictionaryTest extends TestCase {

	/** ターゲット */
	private final TranslationDictionary target = new TranslationDictionary();

	/**
	 * テスト
	 */
	public void testLookup() {

		TranslationResult result = null;
		String input = null;

		input = "... undefined string in dictionary ...";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals(input, result.getValue());
		assertEquals(false, result.isFound());

		input = "Label";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("ラベル", result.getValue());
		assertEquals(true, result.isFound());

		input = "L&abel";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("ラベル(&A)", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Left";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("左(&L)", result.getValue());
		assertEquals(true, result.isFound());

		input = "Search results for {0}:";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("{0} の検索結果:", result.getValue());
		assertEquals(true, result.isFound());

		input = "Remo&ve Buildfile";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("ビルド・ファイルの除去(&V)", result.getValue());
		assertEquals(true, result.isFound());

		input = "Error reading configuration";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("構成の読み取り中にエラーが発生しました", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Extension....";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("拡張(&E)....", result.getValue());
		assertEquals(true, result.isFound());

		// lookupIgnoreMnemonic
		result = target.lookupIgnoreMnemonic("Label");
		System.out.println(input + "=" + result.getValue());
		assertEquals("ラベル", result.getValue());
		assertEquals(true, result.isFound());

		input = "L&abel";
		result = target.lookupIgnoreMnemonic(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals(input, result.getValue());
		assertEquals(false, result.isFound());

		input = "&Next >";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("次へ(&N) >", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Next >>";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("次へ(&N) >>", result.getValue());
		assertEquals(true, result.isFound());

		input = "<< &Previous";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("<< 前へ(&P)", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Using {0} - <a>Select other...</a>";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("{0} を使用中 - <a>その他の選択(&U)...</a>", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Add -->";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("追加(&A) -->", result.getValue());
		assertEquals(true, result.isFound());

		input = "&Color:";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("色(&C):", result.getValue());
		assertEquals(true, result.isFound());

		input = "Add &Include@Ctrl+Shift+N";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("Include の追加(&I)@Ctrl+Shift+N", result.getValue());
		assertEquals(true, result.isFound());

		input = "Go to &Line...@Ctrl+L";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("指定行へジャンプ(&L)...@Ctrl+L", result.getValue());
		assertEquals(true, result.isFound());

		input = "A resource named \"&1\" already exists.";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("リソース \"&1\" はすでに存在します。", result.getValue());
		assertEquals(true, result.isFound());

		input = "K&R [built-in]";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("K&R [ビルトイン]", result.getValue());
		assertEquals(true, result.isFound());

		input = "&nbsp;&nbsp;Go&nbsp;&nbsp;";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("&nbsp;&nbsp;実行&nbsp;&nbsp;", result.getValue());
		assertEquals(true, result.isFound());

		input = "Ignore '&&' in &Java properties files";
		result = target.lookup(input);
		System.out.println(input + "=" + result.getValue());
		assertEquals("Java プロパティー・ファイルの '&&' を無視(&J)", result.getValue());
		assertEquals(true, result.isFound());
	}
}
