/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

import jp.sourceforge.mergedoc.pleiades.util.FastProperties;

/**
 * 英語と日本語のプロパティーを対で保持するクラスです。
 * <p>
 * @author cypher256
 */
public class PropertiesUnit {

	/** 英語プロパティー */
	private FastProperties enProperties = new IgnoreFileNotFoundProperties();

	/** 日本語プロパティー */
	private FastProperties jaProperties = new IgnoreFileNotFoundProperties();
	
	/** ファイルが無い場合、無視するプロパティー */
	private static class IgnoreFileNotFoundProperties extends FastProperties {
		
		private static final long serialVersionUID = 1L;

		@Override
		protected InputStream getInputStream(File file) {
			try {
				return super.getInputStream(file);
			} catch (FileNotFoundException e) {
				return null;
			}
		}
	}
	
	/**
	 * プロパティー・ユニットを構築します。
	 */
	public PropertiesUnit() {
	}

	/**
	 * 英語プロパティーを取得します。
	 * <p>
	 * @return 英語プロパティー
	 */
	public FastProperties getEnProperties() {
		return enProperties;
	}

	/**
	 * 英語プロパティーをセットします。
	 * <p>
	 * @param enProperties 英語プロパティー
	 */
	public void setEnProperties(FastProperties enProperties) {
		this.enProperties = enProperties;
	}
	
	/**
	 * 日本語プロパティーを取得します。
	 * <p>
	 * @return 日本語プロパティー
	 */
	public FastProperties getJaProperties() {
		return jaProperties;
	}

	/**
	 * 日本語プロパティーをセットします。
	 * <p>
	 * @param jaProperties 日本語プロパティー
	 */
	public void setJaProperties(FastProperties jaProperties) {
		this.jaProperties = jaProperties;
	}
}
