/*
 * SMTPclientTest.java
 * JUnit based test
 *
 * Created on 2007/08/10, 0:10
 */

package org.jent.checksmtp;

import junit.framework.*;

/**
 *
 * @author tkyn
 */
public class SMTPclientTest extends TestCase {
  
  public SMTPclientTest(String testName) {
    super(testName);
  }
  
  protected void setUp() throws Exception {
  }
  
  protected void tearDown() throws Exception {
  }
  
  
  /**
   * Stop theard which wait connect from SMTP client
   */
  private void stopClient(SMTPclient instance) {
    System.out.println(">>>>>>>>>>>>>>>>>>>>>>> Set wrong Port number, it will be occurred Faital Error and stop thread.");
    ApplicationProperties.setSmtpPort(65536);
    instance.configChangeNotify();
    sleep();
    System.out.println("<<<<<<<<<<<<<<<<<<<<<<<");
  }
  
  private void sleep() {
    try {
      Thread.sleep(1500); //Wait soTimeOut on accept.  now setSoTimeout(1000);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
  }
  
  /**
   * Test of normal port number, of class org.jent.checksmtp.SMTPclient.
   */
  public void testNormalPortNumber() {
    System.out.println("run testNormalPortNumber");
    
    ApplicationProperties.setSmtpPort(8725);
    SMTPclient instance = new SMTPclient();
    
    assertNotNull(instance);
    stopClient(instance);
    assertNotNull(instance);
  }
  
  /**
   * Test on abnormal port number.
   */
  public void testAbnormalPortNumber() {
    System.out.println("test abnormal port number.");
    
    ApplicationProperties.setSmtpPort(65540);
    SMTPclient instance = new SMTPclient();
    sleep();
    assertNotNull(instance);
    
    ApplicationProperties.setSmtpPort(-1);
    instance = new SMTPclient();
    sleep();
    assertNotNull(instance);
    
  }
  
  
  
}
