/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * WarningServerTrustFrame.java
 *
 * Created on 2011/05/08, 4:36:36
 */
package org.jent.checksmtp.ssl;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.security.cert.X509Certificate;

/**
 *
 * @author Takuya Ono
 */
public class WarningServerTrustFrame extends javax.swing.JFrame {
  RespondingX509TrustManager trustManager;

  /** Creates new form WarningServerTrustFrame */
  public WarningServerTrustFrame(RespondingX509TrustManager trustManager, X509Certificate[] chain) {
    super(); //paranoia statement.
    this.trustManager = trustManager;
    initComponents();
    jTextField.setText(chain[0].getSubjectDN().toString());
    StringBuffer str = new StringBuffer();
    for(int i=0; i<chain.length; i++) {
      str.append(chain[i].toString());
      str.append(System.getProperty("line.separator"));
    }
    jTextArea.setText(str.toString());

    //Move to screen center.
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    this.setBounds(
            (screenSize.width - frameSize.width) / 2,
            (screenSize.height - frameSize.height) / 2,
            frameSize.width, frameSize.height);

    setVisible(true);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jButtonYes = new javax.swing.JButton();
    jButtonNG = new javax.swing.JButton();
    jLabel1 = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    jTextArea = new javax.swing.JTextArea();
    jTextField = new javax.swing.JTextField();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

    jButtonYes.setText("Yes");
    jButtonYes.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonYesActionPerformed(evt);
      }
    });

    jButtonNG.setText("No");
    jButtonNG.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonNGActionPerformed(evt);
      }
    });

    jLabel1.setText("Warning: Untrusted Server Connection");

    jTextArea.setColumns(20);
    jTextArea.setEditable(false);
    jTextArea.setRows(5);
    jScrollPane1.setViewportView(jTextArea);

    jTextField.setEditable(false);
    jTextField.setText("jTextField1");

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addGroup(layout.createSequentialGroup()
            .addContainerGap()
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE)
            .addGap(12, 12, 12))
          .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
            .addGap(106, 106, 106)
            .addComponent(jButtonYes)
            .addGap(53, 53, 53)
            .addComponent(jButtonNG))
          .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
            .addContainerGap()
            .addComponent(jLabel1))
          .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
            .addContainerGap()
            .addComponent(jTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 352, Short.MAX_VALUE)))
        .addGap(0, 0, 0))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(jTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 219, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jButtonNG)
          .addComponent(jButtonYes))
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void jButtonYesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonYesActionPerformed
    trustManager.pushYes();
    dispose();
  }//GEN-LAST:event_jButtonYesActionPerformed

  private void jButtonNGActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNGActionPerformed
    trustManager.pushNo();
    dispose();
  }//GEN-LAST:event_jButtonNGActionPerformed

  /**
   * @param args the command line arguments
   *
  public static void main(String args[]) {
    java.awt.EventQueue.invokeLater(new Runnable() {

      public void run() {
        new WarningServerTrustFrame().setVisible(true);
      }
    });
  }*/
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton jButtonNG;
  private javax.swing.JButton jButtonYes;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea jTextArea;
  private javax.swing.JTextField jTextField;
  // End of variables declaration//GEN-END:variables
}
