
#include "cpSysAfx.h"
#include "cpSysThread.h"
#include <process.h>



LBLThreadCtrl::LBLThreadCtrl()
{
	for( int i=0; i< ECSTYPE_MAX; i++ )
	{
		InitializeCriticalSection(&m_cs[i]);
	}
}

LBLThreadCtrl::~LBLThreadCtrl()
{
	for( int i=0; i< ECSTYPE_MAX; i++ )
	{
		DeleteCriticalSection(&m_cs[i]);
	}
}


int	LBLThreadCtrl::CreateThread(void (*pfunc)(void*), void* argData)
{
	Thread* tmp = new Thread;
	HANDLE hTh = (HANDLE)_beginthread(pfunc,0,argData);
	if (hTh == 0) {
//		CloseHandle(hTh);
		return -1;
	}
	tmp->endCode = false;
	tmp->canDestroy = false;
	tmp->hHandle= hTh;
	tmp->pData = argData;
	m_Thread.push_back(tmp);

	return 0;
}

void	LBLThreadCtrl::Idol()
{
	DWORD dwExit = 0;
	LTL::LTLQueue<Thread*>::iterator i = m_Thread.begin();
	for( ; i < m_Thread.size(); i++ )
	{
		if( (*i).ptObj && !(i->endCode) )
		{
			GetExitCodeThread(i->hHandle, &dwExit );
			if (dwExit == STILL_ACTIVE) {
				
			} else {
				i->endCode = true;
	//			i->canDestroy = true;
                OutputDebugString("I\n");
				break;
			}
		}else if( i->canDestroy )
		{
			delete (Thread*)i.now->ptObj;
			//m_Thread.erase(i);
		}
	}
}

// Critical Section
void	LBLThreadCtrl::GetCriticalSection(ECRITICALTYPE e_type)
{
	EnterCriticalSection(&m_cs[e_type]);
}

void	LBLThreadCtrl::ReleaseCriticalSection(ECRITICALTYPE e_type)
{
	LeaveCriticalSection(&m_cs[e_type]);   
}