﻿<?php
/**
 * Module object file
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Module.php 9 2005-05-26 16:06:47Z madest $
 * @package AccountManager
 * @filesource
 */
 
/**
 * Module object definition
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Module.php 9 2005-05-26 16:06:47Z madest $
 * @package AccountManager
 */
class Module extends AccountManager 
{
	/**
	 * Module name
	 */
	var $modulename;
	
	/**
	 * Module template content
	 * @var String
	 */
	var $template;
	
	/**
	 * Module output content
	 * @var String
	 */
	var $output;
		
	/**
	 * Determines what user is currently logged in and no more mess with sessions for developers
	 * @var Object (Account)
	 */
	var $active_user;
	
	/**
	 * Messages that come from pre-output generation and will be added to end of output.
	 * @var Array - array of strings
	 */
	var $messages;
	
	/**
	 * Constructor of module - when extending execute this in class constructor
	 * to set config, messagecount and active_user
	 */
	function Module()
	{
		$this->modulename = get_class($this);
		$this->AccountManager();
		$this->messagecount = 0;
		$this->setActiveuser();
	}
	
	/**
	 * Check's if user is logged on or not
	 * Useful if you have to know that when creating new module
	 * @return boolean
	 */
	function is_logged()
	{
		if(isset($_SESSION['client_ip']) && isset($_SESSION['acObj']) && isset($_SESSION['login']))
		{
			if($_SESSION['client_ip'] == get_ip() && $_SESSION['logged'] == true)
			{
				return true;
			}else{
				session_destroy();
				return false;
			}
		}else{
			return false;
		}
	}

	/**
	 * Write log messages
	 * @param string - message to write into log
	 */
	function write_log($message)
	{
		if($this->config->manager['log_enabled']==true)
		{
			$client_ip = get_ip();
			$time = time();
			
			$datetime  = gmstrftime("%d/%b/%Y %H:%M:%S GMT", $time);
			$log_filename = "{$this->config->manager['log_path']}/"."access_".gmstrftime("%Y_%m_%d", $time).".log";
	
			if ($fp = @fopen($log_filename, "a")) {
				$data = "[".$datetime."] - [".$client_ip."] - ".$message."\n";
				fputs($fp, $data);
				fclose($fp);
			} else {
				echo "Error in LOG PATH !";
			}
		}
	}
	
	/**
	 * Return output of development messages
	 */
	function DEV_MESSAGES()
	{
		$this->output .= 	"<p align=left><b>--- DEV MESSAGES ---</b><br>";
		
		/*
		// DEBUG SESSION
		$this->output .="<br>";
		$this->output .="<b>Variables from SESSION</b><br>";
		foreach($_SESSION as $key => $val)
		{
			$this->output .= $key."=".$val."<br>";
		}
		
				
		//>Debug Session end
		*/
		
		// DEBUG GET
		/*
		$this->output .="<br>";		
		$this->output .="<b>Variables from URL</b><br>";
		if(isset($_GET))
		{
			foreach($_GET as $key => $val)
			{
				$this->output .= $key."=".$val."<br>";
			}
		}
		*/
		//>Debug Get end
		
		// DEBUG POST
		$this->output .="<br>";
		$this->output .="<b>Variables from POST</b><br>";
		if(isset($_POST))
		{
			foreach($_POST as $key => $val)
			{
				$this->output .= $key."=".$val."<br>";
			}
		}	
	
		//>Debug Post end
		
		/*
		// DEBUG MODULE
		$this->output .="<br>";
		$this->output .="<b>MODULE Specs</b><br>";
		
		$this->output .= "Active_user: ".$this->active_user;
		$this->output .="</p>";
		*/
		//>Debug Module end
	}
	
	/**
	 * If session is set then it reads who is active user currently 
	 * and creates account object of that users
	 */
	function setActiveuser()
	{
		if($this->is_logged() == true)
		{
			$this->active_user = $_SESSION['acObj'];
		} else {
			// No Session
			$this->active_user = null;
		}
	}
	
	/**
	 * Parse messages - messages will be added in the end of module
	 */
	function parseMessages()
	{
		$this->output .= "<br>\n";
		
		
			for ($i=1; $i <= sizeof($this->messages); $i++)
			{
				$this->output .= $this->messages[$i]."<br>\n";
			}
		
	}
	
	/**
	 * Adds message into module messages array
	 * @param string
	 */
	function addMessage($message)
	{		
		$this->messages[sizeof($this->messages) + 1] = $message;
	}
}
?>