﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Threading;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{

    /// <summary>
    /// 状態変数 - このアプリの核
    /// 本来なら全てprivate->getter/setter とすべきだが、コーディングが面倒なので
    /// 明確な理由が在るもののみprivateプロパティにする。
    ///  
    /// </summary>
    public class CurrentContext
    {
        public string nextPage = "";
        public string prevPage = "";

        private string codeAndExchange = ""; // 市場コードつき銘柄コード ( 5202,t )
        private string code = "";            // 銘柄コード  ( 5202 ) ※padと対になる為、直接アクセスは許さない
        private string pad;                  // "0" パディング用のコード 
        public string comapnyName = "";      // 会社名
        public string title;                 // タイトル(カブラウザもどき+銘柄名称)
        public string tid;                   // 掲示板のTopic ID
        public string sid;                   // 掲示板のSID
        public string board;                 // 掲示板のBoard
        public string postUrl;               // 新規投稿するためのURL
        public string maxTilteNo;            // 最新のタイトルNo
        private int prevTitleNo;
        public string mid;                   // 現在表示している message id
        public uint displayRows;
        public string close = "";            // 終値
        public string change = "";           // 前日比
        private AbstractGetYahoo yahoo;
        private YahooSkin skin;              // スキン用の情報


        public StreamReader topicSr;
        public StreamWriter topicSw;
        public bool tFlag = true;  // WEBモード/全文検索モード制御 true = WEBモード（通常）
        public TitleLists[] t;  // WEBから取得した投稿一覧
        public TitleLists[] s;  // 検索結果(全文検索でのみ使用)
        public string selectedTitle = ""; // 表示中メッセージのタイトル(非常に古いメッセージを表示する為に必要)
        private bool lockflag = false;       // ロック中
        /// <summary>
        /// コンストラクタ - 画面に表示する最大件数を渡してオブジェクト生成
        /// </summary>
        /// <param name="maxRow"></param>
        public CurrentContext()
        {
            this.lockflag = false;
        }
        /// <summary>
        /// 表示中のタイトルリストをファイルに保存する
        /// </summary>
        /// <returns></returns>
        public int Save()
        {
            string path = Form1.csDatDir + code + ".dat";
            topicSw = new StreamWriter(path);
            foreach (TitleLists tmp in t) {
                tmp.WriteLine(topicSw);
            }
            topicSw.Close();
            topicSw = null;
            return 0;
        }
        /// <summary>
        /// パディング文字列を返す
        /// </summary>
        /// <returns></returns>
        public string GetPad()
        {
            return this.pad;
        }
        /// <summary>
        /// 銘柄コードを返す
        /// </summary>
        /// <returns></returns>
        public string GetCode()
        {
            return this.code;
        }
        /// <summary>
        /// 銘柄コードをセットする、と同時にゼロ埋め用の
        /// pad変数をセットする。
        /// </summary>
        /// <param name="code"></param>
        public void SetCode(string code)
        {
            int ret = 0;
            this.code = code.Trim();
            if (code.Length == 6) pad = "";
            if (code.Length == 5) pad = "0";
            if (code.Length == 4) pad = "00";

            ret = yahoo.GetTopicId(code);
            ret = yahoo.GetBorad(code);
            ret = yahoo.GetSid(code);

        }

        /// <summary>
        /// TitleNoの最大値をint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetMaxTitleNo()
        {
            if (maxTilteNo != null) {
                return int.Parse(maxTilteNo);
            } else {
                return 0;
            }
        }
        /// <summary>
        /// オブジェクトの保有するTitle List一覧をクリアする。
        /// 次のページを表示する場合呼び出す。
        /// </summary>
        public void ClearTitleList()
        {
            for (int i = 0; i < t.Length; i++) {
                t[i].Clear();
            }
            if (s != null) {
                for (int i = 0; i < s.Length; i++) {
                    s[i].Clear();
                }
            }
        }
        public YahooSkin GetSkin()
        {
            return this.skin;
        }
        public void SetSkin(YahooSkin skin)
        {
            this.skin = skin;
        }
        public void SetYahooInstance(AbstractGetYahoo yahoo)
        {
            this.yahoo = yahoo;

            // TitleListの表示数はYahooのインスタンスに応じて変更
            // textream: 20, 旧掲示板: 40, 
            this.displayRows = yahoo.GetDisplayRows();
            TitleLists[] instance = new TitleLists[displayRows];
            for (int i = 0; i < displayRows; i++) {
                instance[i] = new TitleLists();
            }
            this.t = instance;
        }

        public string GetCodeAndExchange()
        {
            return this.codeAndExchange;
        }
        public void SetCodeAndExchange(string codeAndExchange)
        {
            this.codeAndExchange = codeAndExchange;
        }
        /// <summary>
        /// このオブジェクトの内容をクリアする
        /// 別の銘柄コードを選択時に呼び出す事。
        /// </summary>
        public void Clear()
        {
            this.tid = "";
            this.pad = "";
            this.code = "";
            this.comapnyName = "";
            this.postUrl = "";
            this.prevPage = "";
            this.nextPage = "";
            this.maxTilteNo = "0";
            this.ClearTitleList();
            this.topicSr = null;
            this.topicSw = null;
            this.lockflag = false;
        }

        /// <summary>
        /// このオブジェクトのロックを取得する
        /// </summary>
        /// <returns></returns>
        public bool Lock()
        {
            bool ret;
            if (lockflag) {
                ret = false;
            } else {
                lockflag = true;
                ret = true;
            }
            return ret;
        }
        /// <summary>
        /// このオブジェクトのロックを解放する
        /// </summary>
        /// <returns></returns>
        public void UnLock()
        {
            lockflag = false;
        }
    }

    /// <summary>
    ///投稿タイトルリスト
    /// </summary>
    public class TitleLists
    {
        public string titleNo;
        public string url;
        public string title;
        public string sender;
        public string emotion;
        public string sendTime;
        private string delimiter = Char.ConvertFromUtf32(128);
        // 2013.2.24 textream対応 start
        public string content;
        public string user;  // like this "ofo9hpRxpi4jag2kUo2qOd4-" senderとは異なる
        public string userIcon;
        // 2013.2.24 textream対応 end

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TitleLists()
        {
            this.titleNo = "";
            this.title = "";
            this.url = "";
            this.sendTime = "";
            this.sender = "";
            this.emotion = "";
            this.content = "";
            this.user = "";
        }
        public TitleLists(string[] p)
        {
            if (p.Length < 6) { return; }
            titleNo = p[0];
            this.url = p[1];
            this.title = p[2];
            this.sender = p[3];
            this.emotion = p[4];
            this.sendTime = p[5];
            this.content = "";
            this.user = "";
        }
        public void Clear()
        {
            this.titleNo = "";
            this.url = "";
            this.title = "";
            this.sender = "";
            this.emotion = "";
            this.sendTime = "";
            this.content = "";
            this.user = "";
        }
        // 2013.2.14 textream以前の旧バージョン ここから
        public TitleLists(string p1, string p2, string p3, string p4, string p5, string p6)
        {
            this.titleNo = p1;
            this.url = p2;
            this.title = p3;
            this.sender = p4;
            this.emotion = p5;
            this.sendTime = p6;
        }
        // 2013.2.14 textream以前の旧バージョン ここまで

        public TitleLists(string p1, string p2, string p3, string p4, string p5, string p6, string p7, string p8)
        {
            this.titleNo = p1;
            this.url = p2;
            this.title = p3;
            this.sender = p4;
            this.emotion = p5;
            this.sendTime = p6;
            this.content = p7;
            this.user = p8;
        }
        public override string ToString()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter + emotion;
        }
        public string ToString2()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter
                + emotion + delimiter + content;
        }
        public string ToStringNew()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter
                    + emotion + delimiter + user + content;
        }
        //パスを指定して内容を書き込み
        public int WriteLine(string path)
        {
            using (StreamWriter sw = new StreamWriter(path)) {
                sw.WriteLine(this.ToString());
            }
            return 0;
        }

        //StreamWriteを指定して書き込み
        public int WriteLine(StreamWriter sw)
        {
            sw.WriteLine(this.ToString());
            return 0;
        }
        public int WriteLine(StreamWriter sw, bool newFlag)
        {
            if (!newFlag) {
                sw.WriteLine(this.ToString());
            } else {
                sw.WriteLine(this.ToStringNew());
            }
            return 0;
        }
        public int WriteLine2(StreamWriter sw)
        {
            sw.WriteLine(this.ToString2());
            return 0;
        }          /// <summary>
        /// TitleNoをint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetTitleNo()
        {
            return int.Parse(titleNo);
        }
    }
}
