﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    public abstract class AbstractGetYahoo
    {
        protected CurrentContext context = null;
        protected TextBox console = null;
        protected StatusStrip console2 = null;
        protected Hashtable edinetlist;
        protected WebBrowserController ndbControl = null;
        protected int displayRows = 0;

        abstract public string GetReplyUrl(string mid);
        abstract public string GetThreadUrl(string mid);
        abstract public string GetHalfYearChartUrl();
        abstract public string GetNewsUrl();
        abstract public string GetColum();
        abstract public string GetCompanyInfo();
        abstract public string GetDailyRankingUrl();
        abstract public string GetWeeklyRankingUrl();
        abstract public string GetMonthlyRankingUrl();
        abstract public string GetBaseUrl();
        abstract public string GetMassageUrl(string mid);
        abstract public string GetMessageListFromUserId(string sender);
        abstract public string GetPostedSelf() ;
        abstract public bool IsValidYahooCode(string code);
        abstract public string GetChartHtml(WebBrowser webBrowser1);
        abstract public int GetTopicId(string code);
        abstract public uint GetDisplayRows();
        abstract public void GetOtherInfo(string code, HtmlDocument doc);
        abstract public int GetMaxTitleNo(HtmlDocument doc, bool isCheckLock);
        abstract public int GetSid(string code);
        abstract public int GetBorad(string code);
        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する 
        /// コンテンツの内容はあらかじめ取得している事
        /// </summary>
        /// <param name="mid">メッセージID</param>
        /// <param name="mid">全文検索の場合はfalse, それ以外はtrueで呼び出す</param>
        /// <returns></returns>
        abstract public string GetContents(string mid);
        abstract public void GetTitleLists(string longCode, int pageNo);
        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        ///</summary>
        abstract public void SaveAllTitleList(string code);

    }
}
