﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// AbstractGetYahooクラスの実装。
    /// ローカルファイル(xxxx.dat)から取得したメッセージを表示する。
    /// ヤフー掲示板にアクセスしたときと同様のメッセージを返す
    /// </summary>
    public class GetYahooLocal : AbstractGetYahoo
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="context">CurrentContext</param>
        /// <param name="console">コンソール</param>
        /// <param name="console2">ステータスバー</param>
        /// <param name="ndbControl">WEBブラウザコントロール</param>
        /// <param name="edinetlist">EDINETリスト</param>
        public GetYahooLocal(カブラウザもどき.CurrentContext context, TextBox console, StatusStrip console2, WebBrowserController ndbControl, Hashtable edinetlist)
        {
            this.context = context;
            this.console = console;
            this.console2 = console2;
            this.ndbControl = ndbControl;
            this.edinetlist = edinetlist;
            this.context.SetYahooInstance(this);
        }
        public override string GetPostUrl()
        {
            if (context.GetCode() == "") return "";
            return "";
        }
        public override string GetReplyUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/"+context.GetBoard()+"/"+context.GetTid()+"?comment="+mid;
        }
        public override string GetThreadUrl(string mid)
        {
            return "http://post.messages.yahoo.co.jp/bbs?mm=FN&action=m&board=" + context.GetBoard() + "&tid=" + context.GetTid() + "&sid=" + context.GetSid() + "&mid=" + mid + "&thr=" + mid + "&cur=" + mid;
        }
        public override string GetBaseUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.GetBoard() + "/" + context.GetTid();
        }
        public override string GetMassageUrl(string mid)
        {
            if (context.GetCode() == "") return "";
            return "http://textream.yahoo.co.jp/message/" + context.GetBoard() + "/" + context.GetTid() + "?comment=" + mid;
        }
        public override string GetMessageListFromUserId(string sender)
        {
            if (sender == "") return "";
            foreach (TitleLists t in context.t) {
                if (t.sender == sender) {
                    return "http://textream.yahoo.co.jp/personal/history/comment?user=" + t.user;
                }
            }
            return "";
        }
        /// <summary>
        ///　無条件にtrueを返す
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        public override bool IsValidYahooCode(string code)
        {
            return true;
        }

        /// <summary>
        /// TitleListに表示する件数
        /// ローカル版は全件表示する
        /// </summary>
        /// <returns></returns>
        public override uint GetDisplayRows()
        {
            uint iCnt = 0;
            string line = "";
            if (context.GetCode() == "") {
                return 0 ;
            }
            try {
                using (context.topicSr = new StreamReader(Form1.csDatDir + context.GetCode() + ".dat")) {
                    while ((line = context.topicSr.ReadLine()) != null) {
                        iCnt++;
                    }
                }
                context.topicSr.Close();
            }
            catch (FileNotFoundException e) {
                MessageBox.Show("ローカルにファイルが見つかりません");
                return 0;
            }
            if (iCnt > 0) {
                return --iCnt;
            } else {
                MessageBox.Show("ローカルのファイルが空です");
                return 0;
            }
        }
        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する 
        /// コンテンツの内容はあらかじめ取得している事
        /// </summary>
        /// <param name="mid"></param>
        /// <param name="tFlag"></param>
        /// <returns></returns>
        public override string GetContents(string mid)
        {
            YahooSkin skin = context.GetSkin();
            skin.ContextToSkin(context);
            TitleLists thisTitle = null;
            TitleLists[] titles = null;
            string s = "";

            if (context.tFlag) {
                titles = context.t;
            } else {
                titles = context.s;
            }

            foreach (TitleLists t in titles) {
                if (t.titleNo == mid) {
                    thisTitle = t;
                    break;
                }
            }

            if (thisTitle != null) {
                skin.set("&MESSAGE", thisTitle.content);
                skin.set("&RESURL", GetReplyUrl(mid));
                skin.set("&NUMBER", thisTitle.titleNo);
                skin.set("&TITLE", thisTitle.title);
                skin.set("&NAME", thisTitle.sender);
                skin.set("&FEELINGS", thisTitle.emotion);
                skin.set("&DATE", thisTitle.sendTime);
                skin.set("&M_FINDMSG", GetMessageListFromUserId(thisTitle.sender));
                
            }
            //ニックネームはひとまず置いておく
            //                            skin.set("&M_NICKNAME", e.GetAttribute("HREF").Replace("http://search.messages.yahoo.co.jp/search/?p=", ""));
            return "";
        }


        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        /// ローカル版は何もしない
        ///</summary>
        public override void SaveAllTitleList(string code)
        {
            return ;
        }

        /// <summary>
        /// </summary>
        /// <param name="isCheckLock">使用しない</param>
        /// <returns>0:正常 -1:異常</returns>
        public override string GetTid(string code)
        {
            string ret = "-1";
            if (edinetlist.ContainsKey(code)) {
                ret = ((string)edinetlist[code]).Split(',')[3];
            } else {
                ret = code;
            }
            return ret;
        }

        /// <summary>
        ///  Yahoo掲示板のその他の情報を取得する
        ///  HtmlDocument docには正常なDocumentオブジェクトを渡すこと.
        ///  此処ではチェックしない
        ///  セットする値(context):  codeAndExchange, comapnyName
        ///  セットする値(yahoo):  &DATE, &CLOSE, &CHANGE 
        /// </summary>
        /// <returns>0:正常 -1:異常</returns>
        public override void GetOtherInfo(string code, HtmlDocument doc)
        {

            try {
                // IMG用の市場コードを含んだ銘柄コード
                foreach (HtmlElement e in doc.GetElementsByTagName("IMG")) {
                    string sLink = e.GetAttribute("src");
                    try {
                        if (sLink.Length >= 36 && (sLink.Substring(0, 30) == "http://rchart.yahoo.co.jp/t?s=" ||
                                                   sLink.Substring(0, 30) == "http://gchart.yahoo.co.jp/t?s=")) {
                            string tmp = sLink.ToString().Substring(30, sLink.Length - 30);
                            context.SetCodeAndExchange(tmp.Split('&')[0]);
                            break;
                        }
                    }
                    catch (NullReferenceException exp) {
                        context.SetCodeAndExchange("");
                    }
                }

            }
            catch (IndexOutOfRangeException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            catch (NullReferenceException e) {
                console.AppendText(e.ToString() + Form1.csCrLf);
            }
            return ;
        }
        public override string GetSid(string code)
        {
            string ret = "-1";
            if (edinetlist.ContainsKey(code)) {
                ret = ((string)edinetlist[code]).Split(',')[2];
            } else {
                ret = "100" + code;
            }
            return ret;
        }
        public override string GetBoard(string code)
        {
            string ret = "-1";
            if (edinetlist.ContainsKey(code)) {
                ret = ((string)edinetlist[code]).Split(',')[1];
            } else {
                ret = "100" + code;
            }
            return ret;
        }

        /// <summary>
        /// contextを仲介せず直接TreeViewに書き込むため、Form1で実装
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="mid">中心となるMessageIdを指定する（前後20件を表示）</param>
        /// <returns></returns>
        public override void GetTitleLists(string longCode, int pageNo)
        {
            string[] lines = null;
            string line = "";
            int index = 0;
            uint displayRow = GetDisplayRows();
            if (displayRow == 0) {
                return;
            }

            using (context.topicSr = new StreamReader(Form1.csDatDir + context.GetCode() + ".dat")) {
                context.t = null;
                context.t = new TitleLists[displayRow];
                while ((line = context.topicSr.ReadLine()) != null) {
                    lines = line.Split(Form1.delimiter);
                    if (lines.Length == 6 ) {
                        context.t[index] = new TitleLists();
                        context.t[index].titleNo = lines[0];  // title id 
                        context.t[index].title = lines[1];  // title
                        context.t[index].sender = lines[2];  // sender
                        context.t[index].sendTime = lines[3];  // pubdate
                        context.t[index].emotion = lines[4];  // emotion
                        context.t[index].content = lines[5];
                        index++;
                    }
                }
                lines = null;
            }
            context.topicSr.Close();
            return ;
        }
        public override string GetChartHtml(WebBrowser webBrowser1)
        {
            return "";
        }
        public override string GetDailyRankingUrl()
        {
            return "";
        }
        public override string GetHalfYearChartUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://stocks.finance.yahoo.co.jp/stocks/chart/?code=" + context.GetCodeAndExchange() + "&ct=z&t=6m&q=c&l=off&z=m&p=m5,m25,s&a=v";
        }
        public override string GetCompanyInfo()
        {
            if (context.GetCode() == "") return "";
            return "http://stocks.finance.yahoo.co.jp/stocks/profile/?code=" + context.GetCode();
        }
        /**
         * 引数docにはyahoo.GetBaseUrl()をnavigateした結果を渡すこと
         * */
        public override int GetMaxTitleNo(HtmlDocument doc, bool isCheckLock)
        {
            return context.t.Length;
        }
        public override string GetMonthlyRankingUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://messages.yahoo.co.jp/ranking/stocks/postranking_monthly.html";
        }
        public override string GetNewsUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://stocks.finance.yahoo.co.jp/stocks/news/?code=" + context.GetCode();
        }
        public override string GetColum()
        {
            if (context.GetCode() == "") return "";
            return "http://news.finance.yahoo.co.jp/search/?q=" + context.GetCode();
        }
        public override string GetWeeklyRankingUrl()
        {
            if (context.GetCode() == "") return "";
            return "http://messages.yahoo.co.jp/ranking/stocks/postranking_weekly.html";
        }
        public override string GetPostedSelf()
        {
            return "http://messages.yahoo.co.jp/my.html";
        }
        public override string GetLoginUrl()
        {
            return "";
        }
        public override bool IsValidUrl(HtmlDocument doc)
        {
            return true;
        }
        public override void AutoLogin(DispBrowser browser)
        {
            return;
        }

    }
}
