﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Threading;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// 状態変数 - このアプリの核
    /// 本来なら全てprivate->getter/setter とすべきだが、煩雑になる為
    /// 明確な理由が在る物のみprivateプロパティにする。
    /// </summary>
    public class CurrentContext
    {
        /// <summary>
        /// 次ページURL
        /// </summary>
        public string nextPage = "";
        /// <summary>
        /// 前ページURL
        /// </summary>
        public string prevPage = "";

        private string codeAndExchange = ""; // 市場コードつき銘柄コード ( 5202,t )
        private string code = "";            // 銘柄コード  ( 5202 ) ※padと対になる為、直接アクセスは許さない
        private string pad;                  // "0" パディング用のコード 
        /// <summary>
        /// 会社名
        /// </summary>
        public string comapnyName = ""; 
        /// <summary>
        /// タイトル(カブラウザもどき+銘柄名称)
        /// </summary>
        public string title;               
        private string tid;                  // 掲示板のTopic ID
        private string sid;                  // 掲示板のSID
        private string board;                // 掲示板のBoard
        /// <summary>
        /// 新規投稿URL
        /// </summary>
        public string postUrl;     
        /// <summary>
        /// 最新タイトルNo
        /// </summary>
        public string maxTilteNo;        
        /// <summary>
        /// 現在表示している message id
        /// </summary>
        public string mid;   
        /// <summary>
        /// 1画面に表示するタイトル数
        /// </summary>
        public uint displayRows;
        /// <summary>
        /// 終値。
        /// ※Textream未使用
        /// </summary>
        public string close = "";
        /// <summary>
        /// 前日比。
        /// ※Textream未使用
        /// </summary>
        public string change = ""; 
        private AbstractGetYahoo yahoo;
        private YahooSkin skin;              // スキン用の情報
        private Hashtable edinetlist = null;
        /// <summary>
        /// datファイル読込用StreamReader
        /// </summary>
        public StreamReader topicSr;
        /// <summary>
        /// datファイル書込用StreamWriter
        /// </summary>
        public StreamWriter topicSw;
        /// <summary>
        /// WEBモード/全文検索モード制御 true = WEBモード（通常）
        /// </summary>
        public bool tFlag = true;
        /// <summary>
        /// WEBから取得した投稿一覧
        /// </summary>
        public TitleLists[] t; 
        /// <summary>
        /// 検索結果(全文検索でのみ使用)
        /// </summary>
        public TitleLists[] s;
        /// <summary>
        /// 表示中メッセージのタイトル(非常に古いメッセージを表示する為に必要)
        /// </summary>
        public string selectedTitle = "";
        private bool lockflag = false;       // ロック中
        /// <summary>
        /// コンストラクタ - オブジェクト生成
        /// </summary>
        public CurrentContext()
        {
            this.lockflag = false;
        }
        /// <summary>
        /// 表示中のタイトルリストをファイルに保存する
        /// </summary>
        /// <returns></returns>
        public int Save()
        {
            string path = Form1.csDatDir + code + ".dat";
            topicSw = new StreamWriter(path);
            foreach (TitleLists tmp in t) {
                tmp.WriteLine(topicSw);
            }
            topicSw.Close();
            topicSw = null;
            return 0;
        }
        /// <summary>
        /// パディング文字列を返す
        /// </summary>
        /// <returns></returns>
        private string GetPad()
        {
            return this.pad;
        }
        /// <summary>
        /// 銘柄コードを返す
        /// </summary>
        /// <returns></returns>
        public string GetCode()
        {
            return this.code;
        }
        /// <summary>
        ///  GetYahoo.GetTid()を呼び出す
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <returns>トピックID</returns>
        public string GetTid()
        {
            return yahoo.GetTid(this.code);
        }
        /// <summary>
        ///  GetYahoo.GetBoard()を呼び出す
        /// </summary>
        /// <returns></returns>
        public string GetBoard()
        {
            return yahoo.GetBoard(this.code);
        }
        /// <summary>
        ///  GetYahoo.GetSid()を呼び出す
        /// </summary>
        /// <returns></returns>
        public string GetSid()
        {
            return yahoo.GetSid(this.code);
        }        
        /// <summary>
        /// 銘柄コードをセットする、と同時にゼロ埋め用の
        /// pad変数をセットする。
        /// </summary>
        /// <param name="code"></param>
        public void SetCode(string code)
        {
            int ret = 0;
            this.code = code.Trim();
            if (code.Length == 6) pad = "";
            if (code.Length == 5) pad = "0";
            if (code.Length == 4) pad = "00";

            this.tid = yahoo.GetTid(code);
            this.board = yahoo.GetBoard(code);
            this.sid = yahoo.GetSid(code);
            this.postUrl = yahoo.GetPostUrl();
        }

        /// <summary>
        /// TitleNoの最大値をint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetMaxTitleNo()
        {
            if (maxTilteNo != null) {
                return int.Parse(maxTilteNo);
            } else {
                return 0;
            }
        }
        /// <summary>
        /// オブジェクトの保有するTitle List一覧をクリアする。
        /// 次のページを表示する場合呼び出す。
        /// </summary>
        public void ClearTitleList()
        {
            for (int i = 0; i < t.Length; i++) {
                t[i].Clear();
            }
            if (s != null) {
                for (int i = 0; i < s.Length; i++) {
                    s[i].Clear();
                }
            }
        }
        /// <summary>
        /// Yahooスキンを取得する
        /// </summary>
        /// <returns></returns>
        public YahooSkin GetSkin()
        {
            return this.skin;
        }
        /// <summary>
        /// Yahooスキンをセットする
        /// </summary>
        /// <returns></returns>
        public void SetSkin(YahooSkin skin)
        {
            this.skin = skin;
        }
        /// <summary>
        /// Yahooインスタンスをセットする
        /// </summary>
        /// <returns>なし</returns>
        public void SetYahooInstance(AbstractGetYahoo yahoo)
        {
            this.yahoo = yahoo;

            // TitleListの表示数はYahooのインスタンスに応じて変更
            // textream: 20, 旧掲示板: 40, 
            this.displayRows = yahoo.GetDisplayRows();
            TitleLists[] instance = new TitleLists[displayRows];
            for (int i = 0; i < displayRows; i++) {
                instance[i] = new TitleLists();
            }
            this.t = instance;
        }
        /// <summary>
        /// 市場コードつきの銘柄コードを返す。(例:8058.T)
        /// </summary>
        /// <returns></returns>
        public string GetCodeAndExchange()
        {
            return this.codeAndExchange;
        }
        /// <summary>
        /// 市場コード付き銘柄コードをセットする
        /// </summary>
        /// <param name="codeAndExchange"></param>
        public void SetCodeAndExchange(string codeAndExchange)
        {
            this.codeAndExchange = codeAndExchange;
        }
        /// <summary>
        /// このオブジェクトの内容をクリアする
        /// 別の銘柄コードを選択時に呼び出す事。
        /// </summary>
        public void Clear()
        {
            this.tid = "";
            this.pad = "";
            this.code = "";
            this.comapnyName = "";
            this.postUrl = "";
            this.prevPage = "";
            this.nextPage = "";
            this.maxTilteNo = "0";
            this.ClearTitleList();
            this.topicSr = null;
            this.topicSw = null;
            this.lockflag = false;
        }
        /// <summary>
        /// このオブジェクトのロックを取得する
        /// </summary>
        /// <returns></returns>
        public bool Lock()
        {
            bool ret;
            if (lockflag) {
                ret = false;
            } else {
                lockflag = true;
                ret = true;
            }
            return ret;
        }
        /// <summary>
        /// このオブジェクトのロックを解放する
        /// </summary>
        /// <returns></returns>
        public void UnLock()
        {
            lockflag = false;
        }
        /// <summary>
        /// EDINETコードをセットする。
        /// </summary>
        /// <param name="edinetlist"></param>
        public void SetEdinetList(Hashtable edinetlist){
            this.edinetlist = edinetlist;
        }
    }

    /// <summary>
    ///投稿タイトルリスト
    /// </summary>
    public class TitleLists
    {
        /// <summary>
        /// タイトルNo.
        /// </summary>
        public string titleNo;
        /// <summary>
        /// タイトル
        /// </summary>
        public string title;
        /// <summary>
        /// 投稿者
        /// </summary>
        public string sender;
        /// <summary>
        /// 投稿時の気持ち
        /// </summary>
        public string emotion;
        /// <summary>
        /// 投稿時間
        /// </summary>
        public string sendTime;
        private string delimiter = Char.ConvertFromUtf32(128);
        // 2013.2.24 textream対応 start
        /// <summary>
        /// コンテキスト
        /// </summary>
        public string content;
        /// <summary>
        /// Textream: ユーザーID?
        /// </summary>
        public string user;  // like this "ofo9hpRxpi4jag2kUo2qOd4-" senderとは異なる
        /// <summary>
        /// Textream: ユーザーアイコン
        /// </summary>
        public string userIcon;
        // 2013.2.24 textream対応 end

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TitleLists()
        {
            this.titleNo = "";
            this.title = "";
            this.sendTime = "";
            this.sender = "";
            this.emotion = "";
            this.content = "";
            this.user = "";
        }

        public void Clear()
        {
            this.titleNo = "";
            this.title = "";
            this.sender = "";
            this.emotion = "";
            this.sendTime = "";
            this.content = "";
            this.user = "";
        }
        /// <summary>
        /// 旧掲示板用
        /// 投稿内容を含めない
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter + emotion;
        }
        /// <summary>
        /// Textream用
        /// 投稿内容を含める
        /// </summary>
        /// <returns></returns>
        public string ToString2()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter
                   + emotion + delimiter + content;
        }
        public string ToStringNew()
        {
            return titleNo + delimiter + title + delimiter + sender + delimiter + sendTime + delimiter
                    + emotion + delimiter + user + delimiter + content;
        }
        /// <summary>
        /// パスを指定して内容を書き込み
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public int WriteLine(string path)
        {
            using (StreamWriter sw = new StreamWriter(path)) {
                sw.WriteLine(this.ToString());
            }
            return 0;
        }
        //StreamWriteを指定して書き込み
        public int WriteLine(StreamWriter sw)
        {
            sw.WriteLine(this.ToString());
            return 0;
        }
        public int WriteLine(StreamWriter sw, bool newFlag)
        {
            if (!newFlag) {
                sw.WriteLine(this.ToString());
            } else {
                sw.WriteLine(this.ToStringNew());
            }
            return 0;
        }
        public int WriteLine2(StreamWriter sw)
        {
            sw.WriteLine(this.ToString2());
            return 0;
        }          /// <summary>
        /// TitleNoをint型で返す
        /// </summary>
        /// <returns></returns>
        public int GetTitleNo()
        {
            return int.Parse(titleNo);
        }
    }
}
