package org.junitdoc.core.jdt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.junitdoc.core.rewriter.ASTUtils;
import org.junitdoc.core.rewriter.JDTUtils;
import org.junitdoc.ui.Const;

public class Annotation {

	private AnnotationTypeDeclaration annotationTypeDeclaration;

	public Annotation(AnnotationTypeDeclaration methodDeclaration) {
		this.annotationTypeDeclaration = methodDeclaration;
	}

	public AnnotationTypeDeclaration getSource() {
		return annotationTypeDeclaration;
	}

	public String getName() {
		return annotationTypeDeclaration.getName().getFullyQualifiedName();
	}

	public void selectAndReveal() {
		selectAndReveal(JDTUtils.getActiveJavaEditor());
	}

	public void selectAndReveal(JavaEditor javaEditor) {
		if (javaEditor == null) {
			return;
		}

		javaEditor.selectAndReveal(annotationTypeDeclaration.getName()
				.getStartPosition(), annotationTypeDeclaration.getName()
				.getLength());
	}

	public String getFullName() {

		List<AnnotationTypeDeclaration> list = new ArrayList<AnnotationTypeDeclaration>();
		list.add(annotationTypeDeclaration);

		AnnotationTypeDeclaration parent = annotationTypeDeclaration;

		while (!isRootAnnotationDeclaration(parent)) {
			ASTNode node = parent.getParent();

			if (node instanceof AnnotationTypeDeclaration) {
				AnnotationTypeDeclaration parentAnno = (AnnotationTypeDeclaration) node;
				list.add(parentAnno);

				parent = parentAnno;

			} else {
				throw new IllegalStateException("Illegal Decision Table Def.");
			}
		}

		StringBuilder sb = new StringBuilder();

		for (int i = list.size() - 1; i >= 0; i--) {
			sb.append(list.get(i).getName().getFullyQualifiedName());
			if (i > 0) {
				sb.append(".");
			}
		}

		return sb.toString();
	}

	private boolean isRootAnnotationDeclaration(
			AnnotationTypeDeclaration parentAnno) {
		return ASTUtils.isAnnotated(parentAnno, Const.DECISIONTABLE_ANNOTATION);
	}
}
