package org.junitdoc.core.decisiontable;

import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.junitdoc.core.jdt.Method;
import org.junitdoc.preferences.PreferenceConstants;
import org.junitdoc.preferences.PreferenceUtils;

public class TestMethod extends Method {

	private DecisionTableModel decisionTable;

	private String name;

	private int index;

	public TestMethod(DecisionTableModel decisionTable,
			MethodDeclaration methodDeclaration, int index) {
		super(methodDeclaration);
		this.decisionTable = decisionTable;
		this.name = methodDeclaration.getName().getFullyQualifiedName();
		this.index = index;
	}

	public DecisionTableModel getDecisionTable() {
		return decisionTable;
	}

	public String getName() {
		return name;
	}

	public int getIndex() {
		return index;
	}

	public String getCheckState(Type type) {
		if (isChecked(type)) {
			return PreferenceUtils
					.getString(PreferenceConstants.DECISION_TABLE_CHECK_LABEL);
		}
		return PreferenceUtils
				.getString(PreferenceConstants.DECISION_TABLE_UNCHECK_LABEL);
	}

	public boolean isChecked(Type type) {
		return hasMarkerAnnotation(type.getFullName());
	}

	public MarkerAnnotation getMarkerAnnotation(Type type) {
		return getMarkerAnnotation(type.getFullName());
	}
}
