package org.junitdoc.ui.dialogs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.junitdoc.ui.dialogs.JavaInputValidator.ValidationType;

public class JavaInputDialog extends InputDialog {

	private static final InputValidatorWrapper validator = new InputValidatorWrapper();

	private JavaInputValidator javaInputValidator;

	public JavaInputDialog(Shell parentShell, String dialogTitle,
			String dialogMessage, String initialValue) {
		super(parentShell, dialogTitle, dialogMessage, initialValue, validator);

		javaInputValidator = new JavaInputValidator();
		validator.setDelegate(javaInputValidator);
	}

	public void setZeroLengthMessage(String message) {
		setValidationMessage(JavaInputValidator.ValidationType.LENGTH_ZERO,
				message);
	}

	public void setValidationMessage(ValidationType type, String message) {
		javaInputValidator.setValidationMessage(type, message);
	}

	private static class InputValidatorWrapper implements IInputValidator {

		private IInputValidator delegate;

		public void setDelegate(IInputValidator javaInputValidator) {
			this.delegate = javaInputValidator;
		}

		public String isValid(String value) {
			return delegate.isValid(value);
		}
	}

}
