module jg {
	export interface TriggerHandler {
		owner:any;
		handler:Function;
	}

	export class Trigger {
		handlers:TriggerHandler[];/* i want define it: ((param:any) => void)[];*/

		constructor() {
			this.handlers = []
		}

		handleInsert(index:number, owner:any, handler:Function) {
			this.handlers.splice(index, 0, {owner:owner, handler:handler});
		}

		handle(owner:any, handler?:Function) {
			if (! handler) {
				this.handlers.push({owner:window, handler:owner});
			} else {
				this.handlers.push({owner:owner, handler:handler});
			}
		}

		destroy() {
			this.handlers = new TriggerHandler[];
		}

		removeAll(owner:any) {
			var ret = [];
			var tmp;
			while (tmp = this.handlers.pop()) {
				if (tmp.owner != owner)
					ret.push(tmp);
			}

			this.handlers = ret;
		}

		removeAllByHandler(handler:Function) {
			var ret = [];
			var tmp;
			while (tmp = this.handlers.pop()) {
				if (tmp.handler != handler)
					ret.push(tmp);
			}

			this.handlers = ret;
		}

		remove(owner:any, handler?:Function) {
			var ret = [];
			var tmp;
			if (! handler) {
				handler = owner;
				owner = window;
			}
			while (tmp = this.handlers.pop()) {
				if (tmp.handler != handler || tmp.owner != owner)
					ret.push(tmp);
			}

			this.handlers = ret;
		}

		fire(param?:any) {
			if (this.handlers.length == 0)
				return;
			var handlers = [];
			for (var i=0; i<this.handlers.length; i++)
				handlers[i] = this.handlers[i];

			for (var i=0; i<handlers.length; i++)
				handlers[i].handler.call(handlers[i].owner, param);
		}

		fastFire(param?:any) {
			for (var i=0; i<this.handlers.length; i++)
				this.handlers[i].handler.call(this.handlers[i].owner, param);
		}
	}
}