module jg {
	export class ResourceStructure {
		img:string;
		sound:string;
		static Default:ResourceStructure = new ResourceStructure("img/", "sound/");
		static Plain:ResourceStructure = new ResourceStructure("", "");

		constructor(img:string, sound:string) {
			this.img = img;
			this.sound = sound;
		}

		isAbsolute(url:string) {
			var white = [".","/"];
			if (white.indexOf(url.charAt(0)) >= 0 || url.match(/^(http:|https:|data:)/))
				return url;
		}

		imageUrl(url:string) {
			if (this.isAbsolute(url))
				return url;
			return this.img + url;
		}

		soundUrl(url:string) {
			if (this.isAbsolute(url))
				return url;
			return this.sound + url;
		}
	}
}