module jg {
	export class InputEvent {
		type: InputEventType;
		action: InputEventAction;
		param: any;

		constructor(type:InputEventType, action:InputEventAction, param?:any) {
			this.type = type;
			this.action = action;
			this.param = param;
		}
	}
	export class InputKeyboardEvent extends InputEvent {
		key: Keytype;
		constructor(action:InputEventAction, key:Keytype, e:any) {
			super(InputEventType.Keyboard, action, e);
			this.key = key;
		}
	}
	export class InputPointEvent extends InputEvent {
		x: number;
		y: number;
		point: CommonOffset;
		entity: E;

		constructor(action:InputEventAction, e:any, point:CommonOffset) {
			super(InputEventType.Point, action, e);
			this.point = point;
		}

		set(entity:E) {
			var entityOffset = entity.offset();
			this.entity = entity;
			this.x = this.point.x - entityOffset.x;
			this.y = this.point.y - entityOffset.y;
		}
	}
}