module jg {
	export class CharacterFactory {
		charaCol: number;
		animeCnt: number;
		movePixel: number;
		moveTime: number;
		image: HTMLImageElement;
		width: number;
		height: number;
		wait: number;
		angle: Angle;
		createClass: any;
		angleSeq: any;//{[key:Angle]: number; };

		constructor(image:HTMLImageElement, width:number, height:number) {
			this.width = width;
			this.height = height;
			this.image = image;
			this.wait = 200;
			this.charaCol = 1;
			this.animeCnt = 2;
			this.moveTime = 300;
			this.movePixel = 64;
			this.angle = Angle.Down;
			this.createClass = Character;
		}

		create(charaSeq:number, offset?: CommonOffset, angle?:Angle) {
			var c:Character = new this.createClass(
				this.image,
				this.width,
				this.height,
				this.wait
			);
			var black = ["width", "height", "image", "wait", "angle"];
			for (var i in this) {
				if (typeof this[i] == "function")
					continue;
				if (black.indexOf(i) >= 0)
					continue;
				c[i] = this[i];
			}
			c.charaSeq = charaSeq;

			c.angle(angle == undefined ? this.angle : angle);

			if (offset)
				c.moveTo(offset.x, offset.y);

			return c;
		}
	}
}
